package view;

import java.awt.Container;

import javax.swing.JFrame;

import model.DAO;
import control.Controller;

public class CompStoreGUI {
    private JFrame window;
    private DAO dao;
    private Controller control;
    
    public CompStoreGUI(Controller control) {
    	this.setControl(control);
    	dao = new DAO();
    }
    
    public void startGUI() {
    	javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                createAndShowGUI();
            }
        });
    }
    
    private void createAndShowGUI() {
    	window = new JFrame("Computer Store");
        window.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        CompStoreMenuBar storeMenuBar = new CompStoreMenuBar(this);
        window.setJMenuBar(storeMenuBar);

        window.setSize(800,600);
        window.setResizable(false);
        window.setVisible(true);
    }

    public void setActualContent(Container c){
    	window.setContentPane(c);
    	window.setVisible(true);
    }

	public JFrame getWindow() {
		return window;
	}
	
	public DAO getDAO() {
		return dao;
	}

	public void setControl(Controller control) {
		this.control = control;
	}

	public Controller getControl() {
		return control;
	}
}
