package model;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import model.beans.Computer;

public class DAO {

	private static final String dbfile = "D:\\feladat\\kulso\\db\\feladat.db";
	
	public DAO(){
        try {
        	
			Class.forName("org.sqlite.JDBC");
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} 
	}
	
	public boolean addComputer(Computer c){
		Connection conn = null;
		PreparedStatement pst = null;
		try {
			conn = DriverManager.getConnection("jdbc:sqlite:"+dbfile);
			
			pst = conn.prepareStatement("insert into Computers (type,manufacturer,model,proddate) " +
					"values(?,?,?,?)");
			pst.setString(1, c.getType());
			pst.setString(2, c.getManufacturer());
			pst.setString(3, c.getModel());
			pst.setString(4, c.getProdDate());
			pst.executeUpdate();
			return true;
		} catch (SQLException e) {
			return false;
		} finally {
			try {
				if(pst != null)
					pst.close();
			} catch (SQLException e) {
				e.printStackTrace();
			}
			try {
				if(conn != null)
					conn.close();
			} catch (SQLException e) {
				e.printStackTrace();
			}
		}		
	}
}

