package hu.alkfejl.bookshop.view.dialogs;

import hu.alkfejl.bookshop.common.Labels;
import hu.alkfejl.bookshop.view.BookShopGUI;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RemoveQualifDialog extends JDialog implements ActionListener {

	/**
	 * 
	 */
	private static final long serialVersionUID = 250270387431730752L;

	private JComboBox qualif;
	private JButton remove = new JButton(Labels.remove);
    private JButton close = new JButton(Labels.close);
    
	private BookShopGUI gui;

    public RemoveQualifDialog(BookShopGUI gui, boolean modal) {
        super(gui.getWindow(), modal);
        this.gui = gui;
        this.setTitle(Labels.remove_qualif);
        
        try {
			qualif = new JComboBox(gui.getControl().getQualifs().toArray());
		} catch (SQLException e) {
			qualif = new JComboBox(Labels.qualifs);
		}
		
        JPanel settingPanel = createSettingPanel();
        JPanel buttonPanel = createButtonPanel();
        JPanel dialogPanel = createDialogPanel(settingPanel, buttonPanel);

        getContentPane().add(dialogPanel);
        setPreferredSize(new Dimension(280,90));
        pack();
        setLocationRelativeTo(gui.getWindow());
        setVisible(true);
    }
    
    private JPanel createSettingPanel() {
		JPanel settingPanel = new JPanel();
        settingPanel.setLayout(new GridLayout(1,2));
    	
        settingPanel.add(new JLabel(Labels.qualif_name));
    	settingPanel.add(this.qualif);
    	
    	return settingPanel;
	}
	
	private JPanel createButtonPanel(){
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(FlowLayout.CENTER));
        
        buttonPanel.add(remove);        
        remove.addActionListener(this);
        
        buttonPanel.add(close);        
        close.addActionListener(this);
        
        return buttonPanel;
    }
	
	private JPanel createDialogPanel(JPanel settingPanel, JPanel buttonPanel){
        JPanel dialogPanel = new JPanel();
        dialogPanel.setLayout(new BorderLayout());
        dialogPanel.add(settingPanel, BorderLayout.CENTER);
        dialogPanel.add(buttonPanel, BorderLayout.SOUTH);
        return dialogPanel;
    }
	
	@Override
	public void actionPerformed(ActionEvent arg0) {
		if (remove==arg0.getSource()) {
			if (qualif.getSelectedItem()!=null) {
				try {
					gui.getControl().removeQualif(qualif.getSelectedItem().toString());
					qualif.removeItem(qualif.getSelectedItem());
				} catch (SQLException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}
		if (close==arg0.getSource())
			this.setVisible(false);
	}

}
