package hu.alkfejl.bookshop.view.dialogs;

import hu.alkfejl.bookshop.common.Labels;
import hu.alkfejl.bookshop.view.BookShopGUI;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AddQualifDialog extends JDialog implements ActionListener {

	/**
	 * 
	 */
	private static final long serialVersionUID = -5101273703293611529L;
	
	private JTextField qualif_name = new JTextField(10);
	private JButton ok = new JButton(Labels.ok);
    private JButton cancel = new JButton(Labels.cancel);
	
	private BookShopGUI gui;

    public AddQualifDialog(BookShopGUI gui, boolean modal) {
        super(gui.getWindow(), modal);
        this.gui = gui;
        this.setTitle(Labels.add_qualif);
        
        JPanel settingPanel = createSettingPanel();
        JPanel buttonPanel = createButtonPanel();
        JPanel dialogPanel = createDialogPanel(settingPanel, buttonPanel);

        getContentPane().add(dialogPanel);
        pack();
        setLocationRelativeTo(gui.getWindow());
        setVisible(true);
    }
    
	private JPanel createSettingPanel() {
		JPanel settingPanel = new JPanel();
        settingPanel.setLayout(new GridLayout(1,2));
    	
        settingPanel.add(new JLabel(Labels.qualif_name));
    	settingPanel.add(this.qualif_name);
    	
    	return settingPanel;
	}
	
	private JPanel createButtonPanel(){
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(FlowLayout.CENTER));
        
        buttonPanel.add(ok);        
        ok.addActionListener(this);
        
        buttonPanel.add(cancel);        
        cancel.addActionListener(this);
        
        return buttonPanel;
    }
	
	private JPanel createDialogPanel(JPanel settingPanel, JPanel buttonPanel){
        JPanel dialogPanel = new JPanel();
        dialogPanel.setLayout(new BorderLayout());
        dialogPanel.add(settingPanel, BorderLayout.CENTER);
        dialogPanel.add(buttonPanel, BorderLayout.SOUTH);
        return dialogPanel;
    }
	
	@Override
	public void actionPerformed(ActionEvent arg0) {
		if (ok==arg0.getSource()) {
			if(qualif_name.getText().isEmpty()){
    			JOptionPane.showMessageDialog(gui.getWindow(),
            		    Labels.qualif_is_required,
            		    Labels.error,
            		    JOptionPane.ERROR_MESSAGE);
    			return;
    		}
    		
            try {
				if(!gui.getControl().addQualif(qualif_name.getText()))
					JOptionPane.showMessageDialog(gui.getWindow(),
						    Labels.qualif_exists,
						    Labels.error,
						    JOptionPane.ERROR_MESSAGE);
				else
					setVisible(false);
			} catch (HeadlessException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			} catch (SQLException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}
		if (cancel==arg0.getSource())
			setVisible(false);
	}

}
