﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns="http://www.w3.org/1999/xhtml"
                xmlns:bs="urn:bookshop">
    
    <xsl:output method="html" indent="yes"/>


  <!--
  <xsl:template match="/customers">
    Ilyet nem fogsz látni.
  </xsl:template>

  <xsl:template match="/bs:customers">
    Ilyet fogsz látni.
  </xsl:template>
  -->

  <xsl:template match="/">
      <html>
        <head>
          <title>
            Customer list of 
            <xsl:value-of select="count(bs:customers/bs:customer)"/>
            customers
          </title>
        </head>
        <body>
          <h1>Customer list:</h1>
          <xsl:apply-templates select="bs:customers"/>
        </body>
      </html>
    </xsl:template>

  <xsl:template match="bs:customers">
    <h3>Adults (<xsl:value-of select="count(*[@bs:isStudent = 'false'])"/>):</h3>
    <hr/>
    <table>
      <xsl:apply-templates select="*[@bs:isStudent = 'false']"/>
    </table>

    <h3>Not so adults (<xsl:value-of select="count(*[@bs:isStudent = 'true'])"/>):</h3>
    <hr/>
    <table>
      <xsl:apply-templates select="*[@bs:isStudent = 'true']"/>
    </table>
  </xsl:template>

  <xsl:template match="bs:customer">
    <tr>
      <td><xsl:value-of select="bs:name"/></td>
      <td><xsl:value-of select="bs:qualification"/></td>
      <td><xsl:value-of select="bs:age"/></td>
      <td><xsl:value-of select="bs:address"/></td>
    </tr>
  </xsl:template>
</xsl:stylesheet>
