﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

namespace BookShopWeb
{
    public partial class _Default : System.Web.UI.Page
    {
        /// <summary>
        /// A kliensenként egyetlen controller osztály
        /// </summary>
        protected BookShop.Control.BookShopControl controller
        {
            get 
            {
                // a controller tárolására a session-t
                // használjuk, ugyanis ez az objektum
                // amely a munkamenet alatt nem vész el
                // (értsd: nem keletkezik új példány)
                // az oldalak ugyanis minden betöltéskor
                // egy új példányként jönnek létre
                // a Session tulajdonképpen egy asszociatív tömb
                // melybe bármilyen objektumot elhelyezhetünk 
                // melyet meg szeretnénk tartani a munkamenet során
                // a session kliensenként egyedi
                string key = "Control_" + Session.SessionID; 
                if (Session[key] == null)
                {
                    Session[key] = new BookShop.Control.BookShopControl();
                }
                return (BookShop.Control.BookShopControl)Session[key];
            }
        }

        /// <summary>
        /// Figyelmeztető üzenet megjelenítése javascript-el
        /// Az oldal válaszának részeként állítjuk be
        /// </summary>
        /// <param name="message"></param>
        protected void showMessage(string message)
        {
            Response.Write("<script type='text/javascript'>alert('" + message + "')</script>");
        }
    }
}
