﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

namespace BookShopWeb
{
    // minden oldalunkat a defaultból származtatjuk ugyanis
    // ő tárolja az egyetlen controller példányt
    public partial class AddCustomer : _Default
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            // oldal betöltéskor hívódik
            dlist_qualification.DataSource = controller.ListQualifications();
            dlist_qualification.DataBind();
        }

        //mentés
        protected void btn_ok_Click(object sender, EventArgs e)
        {
            // ha nem adott meg nevet, akkor figyelmezetjük
            if (String.IsNullOrEmpty(tb_name.Text))
            {                
                showMessage("Customer name not specified.");
            }
            else // egyébként mentünk
            {
                BookShop.Model.Customer customer = new BookShop.Model.Customer();
                customer.Name = tb_name.Text;

                // megpróbáljuk számmá alakítani az age mező tartalmát
                int age = 0;
                if (!Int32.TryParse(tb_age.Text, out age))
                {
                    showMessage("Age is not a valid number.");
                    return;
                }
                customer.Age = age;
                customer.Female = rblist_gender.Items[0].Selected;
                customer.Grantee = chk_grantee.Checked;
                customer.Qualification = dlist_qualification.SelectedValue;

                if(controller.NewCustomer(customer))
                {
                    // sikeres mentés után visszairányítjuk a kezdőlapra
                    Response.Redirect("Default.aspx");
                }
                else
                {
                    showMessage("Customer not saved because an error");
                }
            }
        }
    }
}
