﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using BookShop.Control;
using BookShop.Model;

namespace BookShop.View.Dialogs
{
    public partial class SellBookDialog : Form
    {
        private BookShopGui gui;

        public SellBookDialog(BookShopGui gui)
        {
            this.gui = gui;

            InitializeComponent();
        }

        private void SellBook_Load(object sender, EventArgs e)
        {
            BookShopControl control = gui.Controller;

            customerChooserCombo.DataSource =
                control.GetCustomerList().CreateIListOnDemand();
            bookChooserCombo.DataSource =
                control.GetAvailableBookList().CreateIListOnDemand();
        }

        private void cancelButton_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            this.Close();
        }

        private void okButton_Click(object sender, EventArgs e)
        {
            bool success = gui.Controller.SellBook(
                bookChooserCombo.SelectedItem as Book,
                customerChooserCombo.SelectedItem as Customer);

            if (success)
            {
                DialogResult = DialogResult.OK;
                this.Close();
            }
            else
            {
                MessageBox.Show("Valami gigszer van!");
            }
        }
    }


    /// <summary>
    /// Extenson method-nak egy statikus osztályban kell lennie.
    /// </summary>
    static class DataSourceHelper
    {
        internal static IList<T> CreateIListOnDemand<T>(this IEnumerable<T> collection)
        {
            // Az as utasítás megvizsgálja, hogy az objektum az
            // adott osztályból származik-e, vagy az adott
            // interfészt implementálja-e
            // ha igen, akkor egy megfelelő referenciát kapunk
            // ha nem, akkor a visszatérési érték null

            IList<T> rvCollection = collection as IList<T>;

            if (rvCollection == null)
                return new List<T>(collection);
            else
                return rvCollection;
        }
    }
}
