using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using BookShop.Model;

namespace BookShop.View.Dialogs
{
    public partial class AddBookDialog : Form
    {
        private readonly String[] categories = {"Drama", "Romantic", "Sci-fi", "Horror",
                "Fantasy", "Historic", "Scientific", "Classic", "Children"};

        private BookShopGui gui;

        public AddBookDialog(BookShopGui gui)
        {
            this.gui = gui;

            InitializeComponent();

            comboBoxCategory.Items.AddRange(categories);
        }

        private void buttonOk_Click(object sender, EventArgs e)
        {
            // Megj.: az egyenlsg opertor C++ rksg alapjn fell van definilva String-nl
            // s tnylegesen csak tartalomra vizsglja az egyezst nem referencira mint a Java!
            if (textBoxTitle.Text == "" || textBoxAuthor.Text == "")
            {
                MessageBox.Show(this, "You must provide the author and the title of the book!",
                    "Error creating book...",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Exclamation);
            }
            else
            {
                Book book = new Book();

                book.Author = textBoxAuthor.Text;
                book.Title = textBoxTitle.Text;
                book.Year = (int)numericUpDownYear.Value;
                book.Category = comboBoxCategory.SelectedItem.ToString();
                book.Price = Convert.ToInt32(textBoxPrice.Text);
                book.Piece = (int)numericUpDownPiece.Value;

                if (gui.Controller.BuyBook(book))
                {
                    this.DialogResult = DialogResult.OK;
                    this.Close();
                }
                else
                {
                    MessageBox.Show(this, "An unexpected problem occured while adding book.",
                        "Error buying book...",
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Error);
                }
            }
        }
    }
}