package hu.alkfejl.bookshop.view.tablemodels;

import hu.alkfejl.bookshop.common.Labels;
import hu.alkfejl.bookshop.model.bean.Customer;

import java.util.Map;

import javax.swing.table.AbstractTableModel;

//Egyedi tableModelt az AbstractTableModelbol tudunk szarmaztatni 
public class CustomerTableModel extends AbstractTableModel {

	private static final long serialVersionUID = 2093252961204461838L;

	//Az egyes oszlop fejlecek nevei
	private String[] columnNames = new String[]{
			Labels.name, Labels.age, Labels.female,
			Labels.rented, Labels.student, Labels.grantee,
			Labels.qualification};

	//A vasarlokat tartalmazo objektum (ua. mint a DAOban levo)
    Map<Integer, Customer> customers;

    public CustomerTableModel(Map<Integer, Customer> customers){
    	super();
    	//A controlleren keresztul megkapott customerst beallitjuk
    	this.customers = customers;
    }
    
    //Felulirunk nehany fontos metodust
    //Hany oszlopa van a tablazatnak
    public int getColumnCount() {
        return columnNames.length;
    }

    //Hany sora van 
    public int getRowCount() {
        return customers.entrySet().size();
    }

    //Adott oszlopnak mi a neve
    public String getColumnName(int col) {
        return columnNames[col];
    }

    //Adott sorban es oszlopban milyen ertek szerepel
    //Mivel a customers map objektum kulcsa megfelel az adatbazisban automatikusan inkrementalt azonositonak, ami 1-tol indul,
    //viszont a tablazat sorainak szamozasa 0-tol indul, ezert mindig a rowhoz hozza kell adnunk 1-et.(correctedRow)
    public Object getValueAt(int row, int col) {
    	int correctedRow = row + 1;
    	if(columnNames[col].equals(Labels.name))
    		return customers.get(correctedRow).getName();
    	else if(columnNames[col].equals(Labels.age))
    		return customers.get(correctedRow).getAge();
    	else if(columnNames[col].equals(Labels.female))
    		return customers.get(correctedRow).isFemale();
    	else if(columnNames[col].equals(Labels.rented))
    		return customers.get(correctedRow).isRented();
    	else if(columnNames[col].equals(Labels.student))
    		return customers.get(correctedRow).isStudent();
    	else if(columnNames[col].equals(Labels.grantee))
    		return customers.get(correctedRow).isGrantee();
    	else if(columnNames[col].equals(Labels.qualification))
    		return customers.get(correctedRow).getQualif();
    	return Labels.unknown;
    		
    }

    //Nagyon fontos! Eredetileg egy JTable-ben minden sztring
    //Igy viszont ami boolean az checkboxkent jelenik meg.
    public Class<?> getColumnClass(int c) {
    	return getValueAt(0, c).getClass();
    }

    //Nagyon fontos! Eredetileg egy JTable minden mezoje szerkesztheto
    //Jelenleg ezt letiltjuk, a szerkeszteshez a kontrolleren keresztul adatbazis kommunikaciot is implementalni kell!
    public boolean isCellEditable(int row, int col) {
        return false;
    }
}

