package hu.alkfejl.bookshop.view.tablemodels;

import hu.alkfejl.bookshop.common.Labels;
import hu.alkfejl.bookshop.model.bean.Book;

import java.util.Map;

import javax.swing.table.AbstractTableModel;

public class BookTableModel extends AbstractTableModel {
	private static final long serialVersionUID = 2093252961204461838L;

	private String[] columnNames = new String[]{
			Labels.author, Labels.title, Labels.year, Labels.category,
			Labels.price, Labels.piece, Labels.ancient};

	Map<Integer, Book> books;

    public BookTableModel(Map<Integer, Book> books){
    	super();
    	this.books = books;
    }
    
    public int getColumnCount() {
        return columnNames.length;
    }

     public int getRowCount() {
        return books.entrySet().size();
    }

    public String getColumnName(int col) {
        return columnNames[col];
    }

    public Object getValueAt(int row, int col) {
    	int correctedRow = row + 1;
    	if(columnNames[col].equals(Labels.author))
    		return books.get(correctedRow).getAuthor();
    	else if(columnNames[col].equals(Labels.title))
    		return books.get(correctedRow).getTitle();
    	else if(columnNames[col].equals(Labels.year))
    		return books.get(correctedRow).getYear();
    	else if(columnNames[col].equals(Labels.category))
    		return books.get(correctedRow).getCategory();
    	else if(columnNames[col].equals(Labels.price))
    		return books.get(correctedRow).getPrice();
    	else if(columnNames[col].equals(Labels.piece))
    		return books.get(correctedRow).getPiece();
    	else if(columnNames[col].equals(Labels.ancient))
    		return books.get(correctedRow).isAncient();
    	return Labels.unknown;
    		
    }

    public Class<?> getColumnClass(int c) {
        return getValueAt(0, c).getClass();
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }
}
