package hu.alkfejl.bookshop.view.dialogs;

import hu.alkfejl.bookshop.common.Labels;
import hu.alkfejl.bookshop.model.bean.Book;
import hu.alkfejl.bookshop.view.BookShopGUI;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;

public class BuyBookDialog extends JDialog implements ActionListener {

	/**
	 * 
	 */
	private static final long serialVersionUID = 2155515398895747466L;

	private JTextField author = new JTextField(15);
	private JTextField title = new JTextField(15);
	private JSpinner year = new JSpinner();
	private JComboBox category = new JComboBox(Labels.categories);
	private JSpinner price = new JSpinner();
	private JSpinner piece = new JSpinner();
	private JCheckBox ancient = new JCheckBox();
	private JButton ok = new JButton(Labels.ok);
    private JButton cancel = new JButton(Labels.cancel);
    
    private BookShopGUI gui;

    public BuyBookDialog(BookShopGUI gui, boolean modal) {
        super(gui.getWindow(), modal);
        this.gui = gui;
        this.setTitle(Labels.buy_book);
        
        JPanel settingPanel = createSettingPanel();
        JPanel buttonPanel = createButtonPanel();
        JPanel dialogPanel = createDialogPanel(settingPanel, buttonPanel);

        getContentPane().add(dialogPanel);
        setPreferredSize(new Dimension(300,250));
        pack();
        setLocationRelativeTo(gui.getWindow());
        setVisible(true);
    }
    
    private JPanel createSettingPanel(){
        JPanel settingPanel = new JPanel();
        settingPanel.setLayout(new GridLayout(6,2));
    	
        settingPanel.add(new JLabel(Labels.author));
    	settingPanel.add(this.author);
    	
    	settingPanel.add(new JLabel(Labels.title));
    	settingPanel.add(this.title);

    	settingPanel.add(new JLabel(Labels.year));
    	settingPanel.add(year);
    	
    	settingPanel.add(new JLabel(Labels.category));
    	settingPanel.add(category);

    	settingPanel.add(new JLabel(Labels.price));
    	settingPanel.add(price);
    	
    	settingPanel.add(new JLabel(Labels.piece));
    	settingPanel.add(piece);
    	    	
    	return settingPanel;
    }
    
    private JPanel createButtonPanel(){
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(FlowLayout.CENTER));
        buttonPanel.add(ok);        
        ok.addActionListener(this);
        buttonPanel.add(cancel);        
        cancel.addActionListener(this);
        
        return buttonPanel;
    }

    private JPanel createDialogPanel(JPanel settingPanel, JPanel buttonPanel){
        JPanel dialogPanel = new JPanel();
        dialogPanel.setLayout(new BorderLayout());
        dialogPanel.add(settingPanel, BorderLayout.CENTER);
        dialogPanel.add(buttonPanel, BorderLayout.SOUTH);
        
        return dialogPanel;
    }
    
    public void actionPerformed(ActionEvent e) {
        if(ok == e.getSource()) {
        	if(author.getText().isEmpty() || title.getText().isEmpty()){
    			JOptionPane.showMessageDialog(gui.getWindow(),
            		    Labels.author_title_is_required,
            		    Labels.error,
            		    JOptionPane.ERROR_MESSAGE);
    			return;
    		}
    		Book b = new Book();
        	b.setAuthor(author.getText());
        	b.setTitle(title.getText());
        	b.setYear((Integer)year.getValue());
        	b.setCategory(category.getSelectedItem().toString());
        	b.setPrice((Integer)price.getValue());
        	b.setAncient(ancient.isSelected());
        	b.setPiece((Integer)piece.getValue());
        	try {
				if(!gui.getControl().buyBook(b))
				    	JOptionPane.showMessageDialog(gui.getWindow(),
				    		    Labels.book_exists,
				    		    Labels.error,
				    		    JOptionPane.ERROR_MESSAGE);
				else
					setVisible(false);
			} catch (HeadlessException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			} catch (SQLException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
        }
        else if(cancel == e.getSource())
            setVisible(false);
    }	

}
