package hu.alkfejl.bookshop.view.dialogs;

import hu.alkfejl.bookshop.common.Labels;
import hu.alkfejl.bookshop.model.bean.Customer;
import hu.alkfejl.bookshop.view.BookShopGUI;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;


/**
 * @author Fulop Lajos
 * @leiras Ez az osztly lesz az j gyfl felvtelnl megjelen dialgus. 
 */
public class AddCustomerDialog extends JDialog implements ActionListener {

	private static final long serialVersionUID = 2072911996817368496L;

	//A dialgus azon vezrlit melyekre szksg lesz az esemnykezels sorn osztlyvltozknt definiljuk
	private JTextField name_textfield = new JTextField(10);
	private JSpinner age_spinner = new JSpinner();
	private JRadioButton female = new JRadioButton(Labels.female);
	private JRadioButton male = new JRadioButton(Labels.male);
	private JCheckBox grantee = new JCheckBox();
	private JComboBox qualif;
	private JButton ok = new JButton(Labels.ok);
    private JButton cancel = new JButton(Labels.cancel);
    
    private BookShopGUI gui;

    public AddCustomerDialog(BookShopGUI gui, boolean modal) {
        super(gui.getWindow(), modal);
        this.gui = gui;
        //A dialgus cme Add customer lesz
        this.setTitle(Labels.add_customer);
        
        qualif = new JComboBox(Labels.qualifs);
		
        JPanel settingPanel = createSettingPanel();//A belltsokat tartalmaz panel gyrtsa
        JPanel buttonPanel = createButtonPanel();//A gombokat tartalmaz panel gyrtsa
        JPanel dialogPanel = createDialogPanel(settingPanel, buttonPanel); //Az elz kt panelt egy panelre rakjuk 

        getContentPane().add(dialogPanel); //A dialogPanelt rrakjuk a dialgusra
        pack(); //A dialgus megfelel mretnek belltsa (a tartalmazott elemek alapjn)
        setLocationRelativeTo(gui.getWindow()); //A dialgust a BookShopGUI-hoz kpest rajzolja ki
        setVisible(true);//Dialogs megjelentse
    }
    
    private JPanel createSettingPanel(){
        JPanel settingPanel = new JPanel();
        //A panel elrendezse mtrix, 5 sor s 2 oszlop, a cellak egyforma meretuek
        settingPanel.setLayout(new GridLayout(5,2));
    	
        //Az els sorban egy nv cmke s egy szvegmez lesz
        settingPanel.add(new JLabel(Labels.name));
    	settingPanel.add(this.name_textfield);
    	
    	//A msodik sorban egy kor cmke s egy spinner lesz
    	settingPanel.add(new JLabel(Labels.age));
    	settingPanel.add(this.age_spinner);

    	//A harmadik sorban egy nem cmke s kt radiobutton lesz, amit egy ujabb panelen helyezunk el(gender_panel)
    	//A gender_panelre jobbra zrtan egyms utn pakolhatunk vezerloket
    	settingPanel.add(new JLabel(Labels.gender));
    	JPanel gender_panel = new JPanel(new FlowLayout(FlowLayout.RIGHT));
    	gender_panel.add(female);
    	gender_panel.add(male);
    	//alapertelmezesben a female van bekapcsolva
    	female.setSelected(true);
    	//A female-male-bol csak egy vlaszthat ki ezrt egy ButtonGroupba rakjuk oket
        ButtonGroup group = new ButtonGroup();
        group.add(female);
        group.add(male);
        //mivel a radio buttonnak alapertelmezesben nagyobb a magassaga mint a textfieldnek ezert atallitjuk az y koordinatakat
        //akkorara mint a textfieldek eseteben
        //ellenkezo esetben a textfield-ek is aranytalanul magasabbak lesznek - mivel GridLayout-unk van, ahol minden cella egyforma meretu
        male.setPreferredSize(new Dimension(male.getPreferredSize().width,name_textfield.getPreferredSize().height));
        female.setPreferredSize(new Dimension(female.getPreferredSize().width,name_textfield.getPreferredSize().height));
    	settingPanel.add(gender_panel);
    	
    	//A 4. sorban lesz a kedvezmnyezettsg
    	settingPanel.add(new JLabel(Labels.grantee));
    	settingPanel.add(grantee);

    	//A 5. sorban lesz a vgzettsg
    	settingPanel.add(new JLabel(Labels.qualification));
    	settingPanel.add(qualif);
    	
    	
    	return settingPanel;
    }
    
    private JPanel createButtonPanel(){
        JPanel buttonPanel = new JPanel();
        //A panel elrendezse folytonos, kzpre igaztva
        buttonPanel.setLayout(new FlowLayout(FlowLayout.CENTER));
        //Hozzadjuk az ok gombot, s figyelnk r
        buttonPanel.add(ok);        
        ok.addActionListener(this);
        //Hozzadjuk a cancel gombot, s figyelnk r
        buttonPanel.add(cancel);        
        cancel.addActionListener(this);
        return buttonPanel;
    }

    private JPanel createDialogPanel(JPanel settingPanel, JPanel buttonPanel){
        JPanel dialogPanel = new JPanel();
        //A panel elrendezse BorderLayout
        dialogPanel.setLayout(new BorderLayout());
        //Kzpen lesz a settingPanel
        dialogPanel.add(settingPanel, BorderLayout.CENTER);
        //Alul pedig a gombok
        dialogPanel.add(buttonPanel, BorderLayout.SOUTH);
        return dialogPanel;
    }
    
    public void actionPerformed(ActionEvent e) {
        //Ha az ok gombot nyomtk meg, akkor megprbljuk felvenni az gyfelet
    	if(ok == e.getSource()) {
        	//Ha nem adtak meg nevet akkor egy hibazenetet runk ki egy error dialogra(JOptionPane.ERROR_MESSAGE)
    		if(name_textfield.getText().isEmpty()){
    			JOptionPane.showMessageDialog(gui.getWindow(),
            		    Labels.user_name_is_required,
            		    Labels.error,
            		    JOptionPane.ERROR_MESSAGE);
    			return;
    		}
    		//letrehozzuk a customert
        	Customer c = new Customer();
        	c.setName(name_textfield.getText());
        	c.setAge((Integer)age_spinner.getValue());
        	c.setFemale(female.isSelected());
        	c.setGrantee(grantee.isSelected());
        	c.setQualif(qualif.getSelectedItem().toString());
        	//Ha az addCustomer false-t ad vissza akkor egy hibazenetet runk ki egy error dialogra(JOptionPane.ERROR_MESSAGE)
            try {
				if(!gui.getControl().addCustomer(c))
					JOptionPane.showMessageDialog(gui.getWindow(),
						    Labels.user_exists,
						    Labels.error,
						    JOptionPane.ERROR_MESSAGE);
				else
					setVisible(false);
			} catch (HeadlessException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			} catch (SQLException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
        }
        else if(cancel == e.getSource())
            setVisible(false);
    }	
}
