package hu.alkfejl.bookshop.view;

//Az importokat mindig SHIFT+F8-al huzzuk be eclipse alatt!
import hu.alkfejl.bookshop.common.Labels;
import hu.alkfejl.bookshop.view.dialogs.AddCustomerDialog;
import hu.alkfejl.bookshop.view.dialogs.BuyBookDialog;
import hu.alkfejl.bookshop.view.tablemodels.BookTableModel;
import hu.alkfejl.bookshop.view.tablemodels.CustomerTableModel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;

import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;


/**
 * @author Fulop Lajos
 * @leiras A Menu osztly reprezentlja a ment 
 * 		   Azrt teheti ezt meg, mert a JMenuBar osztlybl szrmazik.
 *   	   gy a menure a this objektummal hivatkozhatunk 
 */
public class BookShopMenuBar extends JMenuBar implements ActionListener {

    // A JMenuBar implementlja a Serializable interfszt, emiatt kell a serialVersionUID
	// Ez mshol is elfordulhat
	// Az osztly mellett bal oldalt srga felkiltjel eclipse-ben, rklikkelve Add generated serial version id
	// Kiprobalhatjuk, ha ezt a sort toroljuk
	private static final long serialVersionUID = 2973555574160940115L;
	private BookShopGUI gui;

	public BookShopMenuBar(BookShopGUI gui){
        super();
        this.gui = gui;
        //Hrom menpontot gyrtunk ltalnosan, a createMenuPoint metdussal
        createMenuPoint(Labels.customer, Labels.add_customer, Labels.list_customers);
        createMenuPoint(Labels.book, Labels.buy_book, Labels.list_books);
        createMenuPoint(Labels.sell, Labels.sell_book, Labels.list_sold_books);
    }
       
    private void createMenuPoint(String name, String... subnames){
        JMenu menu;
        //Ltrehozunk egy menupontot az els paramter alapjn
        menu = new JMenu(name);
        //A menupontot hozzadjuk a BookShopMenuBar-hoz
        this.add(menu);
        
        //Az egyes menu itemeket a maradk paramter rtkeivel hozzuk ltre
        for(String subname : subnames){
        	JMenuItem menuItem = new JMenuItem(subname);
	        menu.add(menuItem);
	        //Minden egyes menu itemet figyelnk
	        //A menu itemek esetn a megfigyelst az ActionListener interfsz biztostja
	        //Ezrt a menubar implementlja ezt az interfszt s fellrja az actionPerformed metdust 
	        menuItem.addActionListener(this);
        }        
    }
    
    /* 
     * Az interfszekhez tartoz metdusokat clszer generlni,
     * azutn, hogy megadtuk az implements kulcs utn az interfszt,
     * Jobb klikk + Source + Override/Implement 
     */
	@Override
	public void actionPerformed(ActionEvent arg0) {
		try{
			System.out.println("A kvetkez ment meghvta a felhasznl:" + arg0.getActionCommand());
			//Ha az j gyfl felvtelt vlasztottk, akkor egy AddCustomerDialog-ot indtunk
			if(arg0.getActionCommand().equals(Labels.add_customer))
				new AddCustomerDialog(gui, true);
			if(arg0.getActionCommand().equals(Labels.list_customers)){
				//Csinalunk egy tablazatot, a CustomerTableModel alapjan - ami megkapja a controltol a customereket
				JTable table = new JTable(new CustomerTableModel(gui.getControl().getCustomers()));
				//A tablazatot rarakjuk egy scrollpanere, igy ha az tul nagy lenne az alk. meretehez kepest akkor is gorgetheto lesz
				JScrollPane container = new JScrollPane(table);
				//Ezt a scrollpane-t allitjuk be az alkalmazas ablak tartalmanak
				gui.getWindow().setContentPane(container);
				//Majd megjelenitjuk
				gui.getWindow().setVisible(true);
			}
			if(arg0.getActionCommand().equals(Labels.buy_book)){
				new BuyBookDialog(gui, true);
			}
			if(arg0.getActionCommand().equals(Labels.list_books)){
				JTable table = new JTable(new BookTableModel(gui.getControl().getBooks()));
				JScrollPane container = new JScrollPane(table);
				gui.getWindow().setContentPane(container);
				gui.getWindow().setVisible(true);
			}
		}catch(SQLException e){
			System.err.println(e);
		}
	}
	
}

