package hu.alkfejl.bookshop.view;

import hu.alkfejl.bookshop.controller.BookShopController;

import java.awt.Container;

import javax.swing.JFrame;

/**
 * @author Fulop Lajos
 * @leiras Ez az osztly indtja el a GUI-t, s ezen keresztl rhet el a control osztly a tbbi gui elem szmra.
 */
public class BookShopGUI {
    private JFrame window;
    private BookShopController control;

	public static void main(String[] args) throws ClassNotFoundException{
		BookShopGUI vc = new BookShopGUI(new BookShopController());
		vc.startGUI(); //GUI fellet elindtsa
	}
    
    public BookShopGUI(BookShopController control){
    	this.control = control;
    }
    
    public void startGUI() {
    	//A GUI kirajzolsra s az azon trtn esemnyek kezelsre a Java egy kln szlat hasznl.
    	//Ezen a szlon indtjuk el a createAndShowGUI() metdust. 
        javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                createAndShowGUI();
            }
        });
    }
    
    private void createAndShowGUI() {
    	//A JFrame egy magas szint kontner, egy ablak cmmel s kerettel.
    	//A mi ablakunk cme Book Shop lesz.
        window = new JFrame("Book Shop");
        //Ha bezrjuk az ablakot, akkor alaprtelmezsben azt csak elrejtjuk.
        //Ezt a viselkedst mdostjuk arra, hogy az ablak tnylegesen zrdjon be.
        window.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        //Gyrtunk egy bookMenuBar objektumot
        BookShopMenuBar bookMenuBar = new BookShopMenuBar(this);
        //Amit rrakunk a Book Shop ablakunkra
        window.setJMenuBar(bookMenuBar);

        //Az ablaknak belltjuk a mrett
        window.setSize(800,600);
        window.setResizable(false);
        //Kszen vagyunk, megjelenthetjk az ablakot
        window.setVisible(true);
    }

    public void setActualContent(Container c){
    	window.setContentPane(c);
    	window.setVisible(true);
    }

	public JFrame getWindow() {
		return window;
	}

	public BookShopController getControl() {
		return control;
	}
   
}
