package hu.alkfejl.bookshop.controller;

import hu.alkfejl.bookshop.model.BookShopDAO;
import hu.alkfejl.bookshop.model.bean.Book;
import hu.alkfejl.bookshop.model.bean.Customer;

import java.sql.SQLException;
import java.util.Map;


/**
 * @author Fulop Lajos
 * @leiras Ez az osztly vezrli az egsz programot, valamint a view s model csomagokat kti ssze.
 *         Itt tallhat az zleti logika is. (business logic)
 */
public class BookShopController {
	
	private BookShopDAO dao; // Data Access Object - az adat elrst szolgl objektum
	
	public BookShopController() throws ClassNotFoundException{
		dao = new BookShopDAO(); // Data Access Object - az adat elrst szolgl objektum
	}
	
	//Controller, business logic (zleti logika, szablyok)-ra plda
	//Valaki akkor hallgat ha 14nl fiatalabb, valaki akkor nyugdjas ha 62-nel idsebb
	public boolean addCustomer(Customer c) throws SQLException{
		if(c.getAge() < 14)
			c.setStudent(true);
		else if(c.getAge() > 62)
			c.setRented(true);
		return dao.addCustomer(c);
	}
	
	//DAObol lekerjuk a Customereket
	public Map<Integer,Customer> getCustomers() throws SQLException{
		return dao.getCustomers();
	}
	
	public boolean buyBook(Book b) throws SQLException{
		if(b.getYear()<1900)
			b.setAncient(true);
		else
			b.setAncient(false);
		return dao.buyBook(b);
	}
	
	public Map<Integer,Book> getBooks() throws SQLException{
		return dao.getBooks();
	}
}
