using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using BookShop.Model;

namespace BookShop.View.Dialogs
{
    public partial class AddCustomerDialog : Form
    {
        private readonly String[] qualifications = {"University", "College", 
            "High School", "Elementary School"};

        private BookShopGui gui;

        public AddCustomerDialog(BookShopGui gui)
        {
            this.gui = gui;

            InitializeComponent();

            comboBoxQualification.Items.AddRange(qualifications);
            comboBoxQualification.SelectedIndex = 2;
        }

        /// <summary>
        /// OK gomb lenyomva, el kell menteni az adatokat.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void buttonOk_Click(object sender, EventArgs e)
        {
            // megnzzk ki van-e tltve a nv
            if (String.IsNullOrEmpty(textBoxName.Text))
            {
                MessageBox.Show(this, "The name field is empty! Please fill name first!",
                    "Error creating customer...",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Exclamation);
            }
            else
            {
                Customer customer = new Customer();
                customer.Name = textBoxName.Text;
                customer.Age = (int)numericUpDownAge.Value;
                customer.Female = radioButtonFemale.Checked ? true : false;
                customer.Grantee = checkBoxGrantee.Checked;
                customer.Qualification = comboBoxQualification.SelectedItem.ToString();

                if (gui.Controller.NewCustomer(customer))
                {
                    this.DialogResult = DialogResult.OK;
                    this.Close();
                }
                else
                {
                    MessageBox.Show(this, "Customer with the same name already exists!",
                        "Error creating customer...",
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Error);
                }
            }
        }
    }
}