using System;
using System.Collections.Generic;
using System.Windows.Forms;
using BookShop.View.Dialogs;
using BookShop.Control;
using BookShop.Model;

namespace BookShop.View
{
    /// <summary>
    /// A f ablakunk, mensorral.
    /// 
    /// A "partial" kulcs azt jelzi hogy ms fjl(ok)ban is szerepelhet mg ugyanennek az osztlynak
    /// kdja. A Visual Studio gy vlasztja kett a generlt kdtl a kzzel hozzrtat.
    /// </summary>
    public partial class BookShopGui : Form
    {
        private BookShopControl control;

        /// <summary>
        /// Az "internal" kulcssz hatsra csak ez a program (assembly) ltja
        /// ezt a property-t. Nincs definilva setter, ezrt csak olvasni lehet
        /// az rtket!
        /// </summary>
        internal BookShopControl Controller { get {return control;} }

        public BookShopGui(BookShopControl control)
        {
            this.control = control;
            InitializeComponent();
        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Application.Exit();
        }

        private void newCustomerToolStripMenuItem_Click(object sender, EventArgs e)
        {
            AddCustomerDialog dialog = new AddCustomerDialog(this);
            dialog.ShowDialog();
        }

        private void listCustomersToolStripMenuItem_Click(object sender, EventArgs e)
        {
            IEnumerable<Customer> customers = control.GetCustomerList();

            //foreach (Customer customer in customers)
            //{
            //    Console.WriteLine(customer);
            //}

            // a datagridview csak IList interfszt megvalst osztllyal
            // mkdik, ezrt ha nem ilyen kapunk, akkor talaktjuk

            // az is kulcssz megvizsglja, hogy a bal oldali operandus
            // a jobb oldalinak leszrmazottja-e
            // (interfsz megvalstst is leszrmazsnak rtelmezzk)

            if (!(customers is IList<Customer>))
                // a list megvalstja az IList interfszt
                customers = new List<Customer>(customers);

            customersDGV.DataSource = customers;
            customersDGV.Visible = true;
        }

        private void newBookToolStripMenuItem_Click(object sender, EventArgs e)
        {
            AddBookDialog dialog = new AddBookDialog(this);
            dialog.ShowDialog();
        }

        private void listBooksToolStripMenuItem_Click(object sender, EventArgs e)
        {
            // frisstjk az adatokat
            dataGridViewBooks.DataSource = control.GetAvailableBookList();
            // s megjelentjk
            dataGridViewBooks.Visible = true;
        }

        private void sellBookToolStripMenuItem_Click(object sender, EventArgs e)
        {
            using (SellBookDialog dialog = new SellBookDialog(this))
            {
                dialog.ShowDialog();
            }
        }

        private void soldBooksToolStripMenuItem_Click(object sender, EventArgs e)
        {
            soldBooksDGV.DataSource = control.GetSoldBooks();
            soldBooksDGV.Visible = true;
        }
    }
}