using System;
using System.Collections.Generic;
using System.Text;
using BookShop.Model;

namespace BookShop.Control
{
    /// <summary>
    /// Controller osztly, az zleti logika megvalstsra.
    /// </summary>
    public class BookShopControl
    {
        private BookShopDao dao = new BookShopDao();

        public bool NewCustomer(Customer customer)
        {
            if (customer.Age < 14)
            {
                customer.Student = true;
            }
            else if (customer.Age > 62)
            {
                customer.Rented = true;
            }

            return dao.AddCustomer(customer);
        }

        public IEnumerable<Customer> GetCustomerList()
        {
            return dao.GetAllCustomers();
        }

        /// <summary>
        /// j knyv vsrlsa.
        /// </summary>
        /// <param name="book"></param>
        /// <returns></returns>
        public bool BuyBook(Book book)
        {
            // 1900 eltti knyveket antiknak lltjuk be
            book.Ancient = (book.Year < 1900);

            return dao.AddOrUpdateBook(book);
        }

        /// <summary>
        /// Azon knyvek listjnak lekrse amelybl van eladhat kszlet. Csak azokat adja
        /// vissza ahol a kszlet (Piece) legalbb 1.
        /// </summary>
        /// <returns>eladhat knyvek listja</returns>
        public IEnumerable<Book> GetAvailableBookList()
        {
            // csinlunk egy msolatot a knyvekrl
            List<Book> books = new List<Book>(dao.GetAllBooks());

            foreach (Book book in books)
            {
                // csak azok rdekelnek minket amibl van kszlet
                if (book.Piece < 1)
                {
                    books.Remove(book);
                }
            }

            return books;
        }


        public bool SellBook(Book book, Customer customer)
        {
            return dao.SellBook(book, customer);
        }


        public IEnumerable<SoldBook> GetSoldBooks()
        {
            return dao.GetSoldBooks();
        }
    }
}
