package org.example;

import java.sql.*;

/**
 * Sample Hive JDBC client
 *
 */
public class HiveJDBCClient
{
    private static String driverName = "org.apache.hive.jdbc.HiveDriver";
    private static String LIST_ALL_ENTRIES = "SELECT * FROM personal_entries";

    public static void main( String[] args ) {
        try {
            Class.forName(driverName);
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }

        try(Connection conn = DriverManager.getConnection("jdbc:hive2://localhost:10000/default", "hive", "");
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(LIST_ALL_ENTRIES);
        ) {
            System.out.println(String.format("%s\t\t%s\t\t%s\t%s\t\t%s", "pid",
                                                                         "name",
                                                                         "gender",
                                                                         "last_contacted",
                                                                         "birth_year"));
            while (rs.next()) {
                System.out.println(String.format("%s\t%s\t%s\t%s\t%d", rs.getString(1),
                                                                       rs.getString(2),
                                                                       rs.getString(3),
                                                                       rs.getString(4),
                                                                       rs.getInt(5)));
            }
        } catch (SQLException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}
