/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc;

import io.prestosql.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TStatus;
import io.prestosql.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TStatusCode;
import java.net.URI;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    public static final String URL_PREFIX = "jdbc:hive2://";
    public static final String DEFAULT_PORT = "10000";
    public static final String DEFAULT_DATABASE = "default";
    private static final String URI_JDBC_PREFIX = "jdbc:";

    public static void verifySuccessWithInfo(TStatus status) throws SQLException {
        Utils.verifySuccess(status, true);
    }

    public static void verifySuccess(TStatus status) throws SQLException {
        Utils.verifySuccess(status, false);
    }

    public static void verifySuccess(TStatus status, boolean withInfo) throws SQLException {
        if (status.getStatusCode() != TStatusCode.SUCCESS_STATUS && withInfo && status.getStatusCode() != TStatusCode.SUCCESS_WITH_INFO_STATUS) {
            throw new SQLException(status.getErrorMessage(), status.getSqlState(), status.getErrorCode());
        }
    }

    public static JdbcConnectionParams parseURL(String uri) throws IllegalArgumentException {
        String varStr;
        String confStr;
        JdbcConnectionParams connParams = new JdbcConnectionParams();
        if (!uri.startsWith(URL_PREFIX)) {
            throw new IllegalArgumentException("Bad URL format: Missing prefix jdbc:hive2://");
        }
        if (uri.equalsIgnoreCase(URL_PREFIX)) {
            connParams.setEmbeddedMode(true);
            return connParams;
        }
        URI jdbcURI = URI.create(uri.substring(URI_JDBC_PREFIX.length()));
        if (jdbcURI.getAuthority() != null && jdbcURI.getHost() == null) {
            throw new IllegalArgumentException("Bad URL format. Hostname not found  in authority part of the url: " + jdbcURI.getAuthority() + ". Are you missing a '/' after the hostname ?");
        }
        connParams.setHost(jdbcURI.getHost());
        if (connParams.getHost() == null) {
            connParams.setEmbeddedMode(true);
        } else {
            int port = jdbcURI.getPort();
            if (port == -1) {
                port = Integer.valueOf(DEFAULT_PORT);
            }
            connParams.setPort(port);
        }
        Pattern pattern = Pattern.compile("([^;]*)=([^;]*)[;]?");
        String sessVars = jdbcURI.getPath();
        if (sessVars != null && !sessVars.isEmpty()) {
            String dbName = "";
            if (!(sessVars = sessVars.substring(1)).contains(";")) {
                dbName = sessVars;
            } else {
                dbName = sessVars.substring(0, sessVars.indexOf(59));
                if ((sessVars = sessVars.substring(sessVars.indexOf(59) + 1)) != null) {
                    Matcher sessMatcher = pattern.matcher(sessVars);
                    while (sessMatcher.find()) {
                        if (connParams.getSessionVars().put(sessMatcher.group(1), sessMatcher.group(2)) == null) continue;
                        throw new IllegalArgumentException("Bad URL format: Multiple values for property " + sessMatcher.group(1));
                    }
                }
            }
            if (!dbName.isEmpty()) {
                connParams.setDbName(dbName);
            }
        }
        if ((confStr = jdbcURI.getQuery()) != null) {
            Matcher confMatcher = pattern.matcher(confStr);
            while (confMatcher.find()) {
                connParams.getHiveConfs().put(confMatcher.group(1), confMatcher.group(2));
            }
        }
        if ((varStr = jdbcURI.getFragment()) != null) {
            Matcher varMatcher = pattern.matcher(varStr);
            while (varMatcher.find()) {
                connParams.getHiveVars().put(varMatcher.group(1), varMatcher.group(2));
            }
        }
        return connParams;
    }

    static int getVersionPart(String fullVersion, int position) {
        int version = -1;
        try {
            String[] tokens = fullVersion.split("[\\.-]");
            if (tokens != null && tokens.length > 1 && tokens[position] != null) {
                version = Integer.parseInt(tokens[position]);
            }
        }
        catch (Exception e) {
            version = -1;
        }
        return version;
    }

    public static class JdbcConnectionParams {
        private String host = null;
        private int port;
        private String dbName = "default";
        private Map<String, String> hiveConfs = new HashMap<String, String>();
        private Map<String, String> hiveVars = new HashMap<String, String>();
        private Map<String, String> sessionVars = new HashMap<String, String>();
        private boolean isEmbeddedMode = false;

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getDbName() {
            return this.dbName;
        }

        public Map<String, String> getHiveConfs() {
            return this.hiveConfs;
        }

        public Map<String, String> getHiveVars() {
            return this.hiveVars;
        }

        public boolean isEmbeddedMode() {
            return this.isEmbeddedMode;
        }

        public Map<String, String> getSessionVars() {
            return this.sessionVars;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public void setDbName(String dbName) {
            this.dbName = dbName;
        }

        public void setHiveConfs(Map<String, String> hiveConfs) {
            this.hiveConfs = hiveConfs;
        }

        public void setHiveVars(Map<String, String> hiveVars) {
            this.hiveVars = hiveVars;
        }

        public void setEmbeddedMode(boolean embeddedMode) {
            this.isEmbeddedMode = embeddedMode;
        }

        public void setSessionVars(Map<String, String> sessionVars) {
            this.sessionVars = sessionVars;
        }
    }
}

