/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hive.service.cli.operation;

import io.prestosql.hive.jdbc.;
import io.prestosql.hive.jdbc.$internal.org.apache.hive.service.cli.operation.TableTypeMapping;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ClassicTableTypeMapping
implements TableTypeMapping {
    private final Map<String, String> hiveToClientMap = new HashMap<String, String>();
    private final Map<String, String> clientToHiveMap = new HashMap<String, String>();

    public ClassicTableTypeMapping() {
        this.hiveToClientMap.put(.TableType.MANAGED_TABLE.toString(), ClassicTableTypes.TABLE.toString());
        this.hiveToClientMap.put(.TableType.EXTERNAL_TABLE.toString(), ClassicTableTypes.TABLE.toString());
        this.hiveToClientMap.put(.TableType.VIRTUAL_VIEW.toString(), ClassicTableTypes.VIEW.toString());
        this.clientToHiveMap.put(ClassicTableTypes.TABLE.toString(), .TableType.MANAGED_TABLE.toString());
        this.clientToHiveMap.put(ClassicTableTypes.VIEW.toString(), .TableType.VIRTUAL_VIEW.toString());
    }

    @Override
    public String mapToHiveType(String clientTypeName) {
        if (this.clientToHiveMap.containsKey(clientTypeName)) {
            return this.clientToHiveMap.get(clientTypeName);
        }
        return clientTypeName;
    }

    @Override
    public String mapToClientType(String hiveTypeName) {
        if (this.hiveToClientMap.containsKey(hiveTypeName)) {
            return this.hiveToClientMap.get(hiveTypeName);
        }
        return hiveTypeName;
    }

    @Override
    public Set<String> getTableTypeNames() {
        HashSet<String> typeNameSet = new HashSet<String>();
        for (ClassicTableTypes typeNames : ClassicTableTypes.values()) {
            typeNameSet.add(typeNames.toString());
        }
        return typeNameSet;
    }

    public static enum ClassicTableTypes {
        TABLE,
        VIEW;

    }
}

