/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hive.service.cli;

import io.prestosql.hive.jdbc.;
import io.prestosql.hive.jdbc.$internal.org.apache.hive.service.cli.Type;
import io.prestosql.hive.jdbc.$internal.org.apache.hive.service.cli.TypeQualifiers;
import io.prestosql.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TPrimitiveTypeEntry;
import io.prestosql.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TTypeDesc;
import io.prestosql.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TTypeEntry;
import java.util.List;

public class TypeDescriptor {
    private final Type type;
    private String typeName = null;
    private TypeQualifiers typeQualifiers = null;

    public TypeDescriptor(Type type) {
        this.type = type;
    }

    public TypeDescriptor(TTypeDesc tTypeDesc) {
        List<TTypeEntry> tTypeEntries = tTypeDesc.getTypes();
        TPrimitiveTypeEntry top = tTypeEntries.get(0).getPrimitiveEntry();
        this.type = Type.getType(top.getType());
        if (top.isSetTypeQualifiers()) {
            this.setTypeQualifiers(TypeQualifiers.fromTTypeQualifiers(top.getTypeQualifiers()));
        }
    }

    public TypeDescriptor(String typeName) {
        this.type = Type.getType(typeName);
        if (this.type.isComplexType()) {
            this.typeName = typeName;
        } else if (this.type.isQualifiedType()) {
            .PrimitiveTypeInfo pti = .TypeInfoFactory.getPrimitiveTypeInfo((String)typeName);
            this.setTypeQualifiers(TypeQualifiers.fromTypeInfo(pti));
        }
    }

    public Type getType() {
        return this.type;
    }

    public TTypeDesc toTTypeDesc() {
        TPrimitiveTypeEntry primitiveEntry = new TPrimitiveTypeEntry(this.type.toTType());
        if (this.getTypeQualifiers() != null) {
            primitiveEntry.setTypeQualifiers(this.getTypeQualifiers().toTTypeQualifiers());
        }
        TTypeEntry entry = TTypeEntry.primitiveEntry(primitiveEntry);
        TTypeDesc desc = new TTypeDesc();
        desc.addToTypes(entry);
        return desc;
    }

    public String getTypeName() {
        if (this.typeName != null) {
            return this.typeName;
        }
        return this.type.getName();
    }

    public TypeQualifiers getTypeQualifiers() {
        return this.typeQualifiers;
    }

    public void setTypeQualifiers(TypeQualifiers typeQualifiers) {
        this.typeQualifiers = typeQualifiers;
    }
}

