/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hive.service.cli;

import io.prestosql.hive.jdbc.$internal.org.apache.hive.service.cli.Handle;
import io.prestosql.hive.jdbc.$internal.org.apache.hive.service.cli.OperationType;
import io.prestosql.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TOperationHandle;
import io.prestosql.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.TProtocolVersion;

public class OperationHandle
extends Handle {
    private final OperationType opType;
    private final TProtocolVersion protocol;
    private boolean hasResultSet = false;

    public OperationHandle(OperationType opType, TProtocolVersion protocol) {
        this.opType = opType;
        this.protocol = protocol;
    }

    public OperationHandle(TOperationHandle tOperationHandle) {
        this(tOperationHandle, TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V1);
    }

    public OperationHandle(TOperationHandle tOperationHandle, TProtocolVersion protocol) {
        super(tOperationHandle.getOperationId());
        this.opType = OperationType.getOperationType(tOperationHandle.getOperationType());
        this.hasResultSet = tOperationHandle.isHasResultSet();
        this.protocol = protocol;
    }

    public OperationType getOperationType() {
        return this.opType;
    }

    public void setHasResultSet(boolean hasResultSet) {
        this.hasResultSet = hasResultSet;
    }

    public boolean hasResultSet() {
        return this.hasResultSet;
    }

    public TOperationHandle toTOperationHandle() {
        TOperationHandle tOperationHandle = new TOperationHandle();
        tOperationHandle.setOperationId(this.getHandleIdentifier().toTHandleIdentifier());
        tOperationHandle.setOperationType(this.opType.toTOperationType());
        tOperationHandle.setHasResultSet(this.hasResultSet);
        return tOperationHandle;
    }

    public TProtocolVersion getProtocolVersion() {
        return this.protocol;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.opType == null ? 0 : this.opType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OperationHandle)) {
            return false;
        }
        OperationHandle other = (OperationHandle)obj;
        return this.opType == other.opType;
    }

    @Override
    public String toString() {
        return "OperationHandle [opType=" + (Object)((Object)this.opType) + ", getHandleIdentifier()=" + this.getHandleIdentifier() + "]";
    }
}

