/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hive.service.auth;

import io.prestosql.hive.jdbc.;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hive.conf.HiveConf;
import io.prestosql.hive.jdbc.$internal.org.apache.hive.service.auth.AuthenticationProviderFactory;
import io.prestosql.hive.jdbc.$internal.org.apache.hive.service.auth.PasswdAuthenticationProvider;
import io.prestosql.hive.jdbc.$internal.org.apache.hive.service.auth.TSetIpAddressProcessor;
import io.prestosql.hive.jdbc.$internal.org.apache.hive.service.cli.thrift.ThriftCLIService;
import io.prestosql.hive.jdbc.$internal.org.apache.thrift.TProcessor;
import io.prestosql.hive.jdbc.$internal.org.apache.thrift.TProcessorFactory;
import io.prestosql.hive.jdbc.$internal.org.apache.thrift.transport.TSaslClientTransport;
import io.prestosql.hive.jdbc.$internal.org.apache.thrift.transport.TSaslServerTransport;
import io.prestosql.hive.jdbc.$internal.org.apache.thrift.transport.TTransport;
import io.prestosql.hive.jdbc.$internal.org.apache.thrift.transport.TTransportFactory;
import java.io.IOException;
import java.security.Security;
import java.util.HashMap;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.sasl.AuthenticationException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;

public class PlainSaslHelper {
    public static TProcessorFactory getPlainProcessorFactory(ThriftCLIService service) {
        return new SQLPlainProcessorFactory(service);
    }

    public static TTransportFactory getPlainTransportFactory(String authTypeStr) throws LoginException {
        TSaslServerTransport.Factory saslFactory = new TSaslServerTransport.Factory();
        try {
            saslFactory.addServerDefinition("PLAIN", authTypeStr, null, new HashMap<String, String>(), new PlainServerCallbackHandler(authTypeStr));
        }
        catch (AuthenticationException e) {
            throw new LoginException("Error setting callback handler" + e);
        }
        return saslFactory;
    }

    public static TTransport getPlainTransport(String userName, String passwd, TTransport underlyingTransport) throws SaslException {
        return new TSaslClientTransport("PLAIN", null, null, null, new HashMap<String, String>(), new PlainClientbackHandler(userName, passwd), underlyingTransport);
    }

    static {
        Security.addProvider(new .PlainSaslServer.SaslPlainProvider());
    }

    private static class SQLPlainProcessorFactory
    extends TProcessorFactory {
        private final ThriftCLIService service;
        private final HiveConf conf;

        public SQLPlainProcessorFactory(ThriftCLIService service) {
            super(null);
            this.service = service;
            this.conf = service.getHiveConf();
        }

        @Override
        public TProcessor getProcessor(TTransport trans) {
            return new TSetIpAddressProcessor(this.service);
        }
    }

    public static class PlainClientbackHandler
    implements CallbackHandler {
        private final String userName;
        private final String passWord;

        public PlainClientbackHandler(String userName, String passWord) {
            this.userName = userName;
            this.passWord = passWord;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            Object ac = null;
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof NameCallback) {
                    NameCallback nameCallback = (NameCallback)callbacks[i];
                    nameCallback.setName(this.userName);
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    PasswordCallback passCallback = (PasswordCallback)callbacks[i];
                    passCallback.setPassword(this.passWord.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i]);
            }
        }
    }

    private static class PlainServerCallbackHandler
    implements CallbackHandler {
        private final AuthenticationProviderFactory.AuthMethods authMethod;

        public PlainServerCallbackHandler(String authMethodStr) throws AuthenticationException {
            this.authMethod = AuthenticationProviderFactory.AuthMethods.getValidAuthMethod(authMethodStr);
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            String userName = null;
            String passWord = null;
            AuthorizeCallback ac = null;
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callbacks[i];
                    userName = nc.getName();
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callbacks[i];
                    passWord = new String(pc.getPassword());
                    continue;
                }
                if (callbacks[i] instanceof AuthorizeCallback) {
                    ac = (AuthorizeCallback)callbacks[i];
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i]);
            }
            PasswdAuthenticationProvider provider = AuthenticationProviderFactory.getAuthenticationProvider(this.authMethod);
            provider.Authenticate(userName, passWord);
            if (ac != null) {
                ac.setAuthorized(true);
            }
        }
    }
}

