/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;

public class HostsFileReader {
    private Set<String> includes = new HashSet<String>();
    private Set<String> excludes = new HashSet<String>();
    private String includesFile;
    private String excludesFile;

    public HostsFileReader(String inFile, String exFile) throws IOException {
        this.includesFile = inFile;
        this.excludesFile = exFile;
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFileToSet(String filename, Set<String> set) throws IOException {
        FileInputStream fis = new FileInputStream(new File(filename));
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(fis));
            while ((line = reader.readLine()) != null) {
                String[] nodes = line.split("[ \t\n\f\r]+");
                if (nodes == null) continue;
                for (int i = 0; i < nodes.length; ++i) {
                    if (nodes[i].equals("")) continue;
                    set.add(nodes[i]);
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            fis.close();
        }
    }

    public synchronized void refresh() throws IOException {
        this.includes.clear();
        this.excludes.clear();
        if (!this.includesFile.equals("")) {
            this.readFileToSet(this.includesFile, this.includes);
        }
        if (!this.excludesFile.equals("")) {
            this.readFileToSet(this.excludesFile, this.excludes);
        }
    }

    public Set<String> getHosts() {
        return this.includes;
    }

    public Set<String> getExcludedHosts() {
        return this.excludes;
    }

    public synchronized void setIncludesFile(String includesFile) {
        this.includesFile = includesFile;
    }

    public synchronized void setExcludesFile(String excludesFile) {
        this.excludesFile = excludesFile;
    }

    public synchronized void updateFileNames(String includesFile, String excludesFile) throws IOException {
        this.setIncludesFile(includesFile);
        this.setExcludesFile(excludesFile);
    }
}

