/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.util;

import java.io.File;
import java.io.IOException;

public class DiskChecker {
    public static boolean mkdirsWithExistsCheck(File dir) {
        if (dir.mkdir() || dir.exists()) {
            return true;
        }
        File canonDir = null;
        try {
            canonDir = dir.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        String parent = canonDir.getParent();
        return parent != null && DiskChecker.mkdirsWithExistsCheck(new File(parent)) && (canonDir.mkdir() || canonDir.exists());
    }

    public static void checkDir(File dir) throws DiskErrorException {
        if (!DiskChecker.mkdirsWithExistsCheck(dir)) {
            throw new DiskErrorException("can not create directory: " + dir.toString());
        }
        if (!dir.isDirectory()) {
            throw new DiskErrorException("not a directory: " + dir.toString());
        }
        if (!dir.canRead()) {
            throw new DiskErrorException("directory is not readable: " + dir.toString());
        }
        if (!dir.canWrite()) {
            throw new DiskErrorException("directory is not writable: " + dir.toString());
        }
    }

    public static class DiskOutOfSpaceException
    extends IOException {
        public DiskOutOfSpaceException(String msg) {
            super(msg);
        }
    }

    public static class DiskErrorException
    extends IOException {
        public DiskErrorException(String msg) {
            super(msg);
        }
    }
}

