/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.security.authorize;

import io.prestosql.hive.jdbc.$internal.org.apache.commons.logging.Log;
import io.prestosql.hive.jdbc.$internal.org.apache.commons.logging.LogFactory;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.security.UserGroupInformation;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.security.authorize.AuthorizationException;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.security.authorize.ConnectionPermission;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;

public class ServiceAuthorizationManager {
    private static final Log LOG = LogFactory.getLog(ServiceAuthorizationManager.class);
    public static final String SERVICE_AUTHORIZATION_CONFIG = "hadoop.security.authorization";
    private static Map<Class<?>, Permission> protocolToPermissionMap = Collections.synchronizedMap(new HashMap());

    public static void authorize(Subject user, Class<?> protocol) throws AuthorizationException {
        Permission permission = protocolToPermissionMap.get(protocol);
        if (permission == null) {
            permission = new ConnectionPermission(protocol);
            protocolToPermissionMap.put(protocol, permission);
        }
        ServiceAuthorizationManager.checkPermission(user, permission);
    }

    private static void checkPermission(Subject user, final Permission ... permissions) throws AuthorizationException {
        try {
            Subject.doAs(user, new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        for (Permission permission : permissions) {
                            AccessController.checkPermission(permission);
                        }
                    }
                    catch (AccessControlException ace) {
                        LOG.info("Authorization failed for " + UserGroupInformation.getCurrentUGI(), ace);
                        throw new AuthorizationException(ace);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new AuthorizationException(e.getException());
        }
    }
}

