/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.security.authorize;

import io.prestosql.hive.jdbc.$internal.org.apache.commons.logging.Log;
import io.prestosql.hive.jdbc.$internal.org.apache.commons.logging.LogFactory;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.conf.Configurable;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.conf.Configuration;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.security.Group;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.security.SecurityUtil;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.security.User;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.security.authorize.PolicyProvider;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.security.authorize.Service;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ConfiguredPolicy
extends Policy
implements Configurable {
    public static final String HADOOP_POLICY_FILE = "hadoop-policy.xml";
    private static final Log LOG = LogFactory.getLog(ConfiguredPolicy.class);
    private Configuration conf;
    private PolicyProvider policyProvider;
    private volatile Map<Principal, Set<Permission>> permissions;
    private volatile Set<Permission> allowedPermissions;

    public ConfiguredPolicy(Configuration conf, PolicyProvider policyProvider) {
        this.conf = conf;
        this.policyProvider = policyProvider;
        this.refresh();
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
        this.refresh();
    }

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        if (domain.getPrincipals().length == 0) {
            return true;
        }
        return super.implies(domain, permission);
    }

    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        PermissionCollection permissionCollection = super.getPermissions(domain);
        for (Principal principal : domain.getPrincipals()) {
            Set<Permission> principalPermissions = this.permissions.get(principal);
            if (principalPermissions != null) {
                for (Permission permission : principalPermissions) {
                    permissionCollection.add(permission);
                }
            }
            for (Permission permission : this.allowedPermissions) {
                permissionCollection.add(permission);
            }
        }
        return permissionCollection;
    }

    @Override
    public void refresh() {
        String policyFile = System.getProperty("hadoop.policy.file", HADOOP_POLICY_FILE);
        Configuration policyConf = new Configuration(this.conf);
        policyConf.addResource(policyFile);
        HashMap<Principal, Set<Permission>> newPermissions = new HashMap<Principal, Set<Permission>>();
        HashSet<Permission> newAllowPermissions = new HashSet<Permission>();
        Service[] services = this.policyProvider.getServices();
        if (services != null) {
            for (Service service : services) {
                SecurityUtil.AccessControlList acl = new SecurityUtil.AccessControlList(policyConf.get(service.getServiceKey(), "*"));
                if (acl.allAllowed()) {
                    newAllowPermissions.add(service.getPermission());
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Policy - " + service.getPermission() + " * ");
                    continue;
                }
                for (String user : acl.getUsers()) {
                    this.addPermission(newPermissions, new User(user), service.getPermission());
                }
                for (String group : acl.getGroups()) {
                    this.addPermission(newPermissions, new Group(group), service.getPermission());
                }
            }
        }
        this.allowedPermissions = newAllowPermissions;
        this.permissions = newPermissions;
    }

    private void addPermission(Map<Principal, Set<Permission>> permissions, Principal principal, Permission permission) {
        Set<Permission> principalPermissions = permissions.get(principal);
        if (principalPermissions == null) {
            principalPermissions = new HashSet<Permission>();
            permissions.put(principal, principalPermissions);
        }
        principalPermissions.add(permission);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Policy - Adding  " + permission + " to " + principal);
        }
    }
}

