/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.security;

import io.prestosql.hive.jdbc.$internal.org.apache.commons.logging.Log;
import io.prestosql.hive.jdbc.$internal.org.apache.commons.logging.LogFactory;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.conf.Configuration;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.Writable;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.security.SecurityUtil;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.security.UnixUserGroupInformation;
import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;

public abstract class UserGroupInformation
implements Writable,
Principal {
    public static final Log LOG = LogFactory.getLog(UserGroupInformation.class);
    private static UserGroupInformation LOGIN_UGI = null;
    private static final ThreadLocal<Subject> currentUser = new ThreadLocal();

    public static UserGroupInformation getCurrentUGI() {
        Subject user = UserGroupInformation.getCurrentUser();
        if (user == null && (user = currentUser.get()) == null) {
            return null;
        }
        Set<UserGroupInformation> ugiPrincipals = user.getPrincipals(UserGroupInformation.class);
        UserGroupInformation ugi = null;
        if (ugiPrincipals != null && ugiPrincipals.size() == 1) {
            ugi = ugiPrincipals.iterator().next();
            if (ugi == null) {
                throw new RuntimeException("Cannot find _current user_ UGI in the Subject!");
            }
        } else {
            throw new RuntimeException("Cannot resolve current user from subject, which had " + ugiPrincipals.size() + " UGI principals!");
        }
        return ugi;
    }

    @Deprecated
    public static void setCurrentUGI(UserGroupInformation ugi) {
        UserGroupInformation.setCurrentUser(ugi);
    }

    static Subject getCurrentUser() {
        return Subject.getSubject(AccessController.getContext());
    }

    public static void setCurrentUser(UserGroupInformation ugi) {
        Subject user = SecurityUtil.getSubject(ugi);
        currentUser.set(user);
    }

    public abstract String getUserName();

    public abstract String[] getGroupNames();

    public static UserGroupInformation login(Configuration conf) throws LoginException {
        if (LOGIN_UGI == null) {
            LOGIN_UGI = UnixUserGroupInformation.login(conf);
        }
        return LOGIN_UGI;
    }

    public static UserGroupInformation readFrom(Configuration conf) throws IOException {
        try {
            return UnixUserGroupInformation.readFromConf(conf, "hadoop.job.ugi");
        }
        catch (LoginException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }
}

