/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.record.compiler;

import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.record.compiler.CodeBuffer;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.record.compiler.JType;

public class JByte
extends JType {
    public JByte() {
        this.setJavaType(new JavaByte());
        this.setCppType(new CppByte());
        this.setCType(new JType.CType(this));
    }

    @Override
    String getSignature() {
        return "b";
    }

    class CppByte
    extends JType.CppType {
        CppByte() {
            super(JByte.this, "int8_t");
        }

        @Override
        String getTypeIDObjectString() {
            return "new ::hadoop::TypeID(::hadoop::RIOTYPE_BYTE)";
        }
    }

    class JavaByte
    extends JType.JavaType {
        JavaByte() {
            super(JByte.this, "byte", "Byte", "Byte", "TypeID.RIOType.BYTE");
        }

        @Override
        String getTypeIDObjectString() {
            return "io.prestosql.hive.jdbc.$internal.org.apache.hadoop.record.meta.TypeID.ByteTypeID";
        }

        @Override
        void genSlurpBytes(CodeBuffer cb, String b, String s, String l) {
            cb.append("{\n");
            cb.append("if (" + l + "<1) {\n");
            cb.append("throw new java.io.IOException(\"Byte is exactly 1 byte. Provided buffer is smaller.\");\n");
            cb.append("}\n");
            cb.append(s + "++; " + l + "--;\n");
            cb.append("}\n");
        }

        @Override
        void genCompareBytes(CodeBuffer cb) {
            cb.append("{\n");
            cb.append("if (l1<1 || l2<1) {\n");
            cb.append("throw new java.io.IOException(\"Byte is exactly 1 byte. Provided buffer is smaller.\");\n");
            cb.append("}\n");
            cb.append("if (b1[s1] != b2[s2]) {\n");
            cb.append("return (b1[s1]<b2[s2])?-1:0;\n");
            cb.append("}\n");
            cb.append("s1++; s2++; l1--; l2--;\n");
            cb.append("}\n");
        }
    }
}

