/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.net;

import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.net.DNSToSwitchMapping;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.net.NetUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CachedDNSToSwitchMapping
implements DNSToSwitchMapping {
    private Map<String, String> cache = new ConcurrentHashMap<String, String>();
    protected DNSToSwitchMapping rawMapping;

    public CachedDNSToSwitchMapping(DNSToSwitchMapping rawMapping) {
        this.rawMapping = rawMapping;
    }

    @Override
    public List<String> resolve(List<String> names) {
        names = NetUtils.normalizeHostNames(names);
        ArrayList<String> result = new ArrayList<String>(names.size());
        if (names.isEmpty()) {
            return result;
        }
        ArrayList<String> unCachedHosts = new ArrayList<String>(names.size());
        for (String name : names) {
            if (this.cache.get(name) != null) continue;
            unCachedHosts.add(name);
        }
        List<String> rNames = this.rawMapping.resolve(unCachedHosts);
        if (rNames != null) {
            for (int i = 0; i < unCachedHosts.size(); ++i) {
                this.cache.put((String)unCachedHosts.get(i), rNames.get(i));
            }
        }
        for (String name : names) {
            String networkLocation = this.cache.get(name);
            if (networkLocation != null) {
                result.add(networkLocation);
                continue;
            }
            return null;
        }
        return result;
    }
}

