/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapreduce;

import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.conf.Configuration;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.BytesWritable;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.DataInputBuffer;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.RawComparator;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.serializer.Deserializer;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.serializer.SerializationFactory;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.RawKeyValueIterator;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapreduce.Counter;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapreduce.OutputCommitter;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapreduce.RecordWriter;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapreduce.StatusReporter;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapreduce.TaskAttemptID;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapreduce.TaskInputOutputContext;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.util.Progressable;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ReduceContext<KEYIN, VALUEIN, KEYOUT, VALUEOUT>
extends TaskInputOutputContext<KEYIN, VALUEIN, KEYOUT, VALUEOUT> {
    private RawKeyValueIterator input;
    private Counter inputKeyCounter;
    private Counter inputValueCounter;
    private RawComparator<KEYIN> comparator;
    private KEYIN key;
    private VALUEIN value;
    private boolean firstValue = false;
    private boolean nextKeyIsSame = false;
    private boolean hasMore;
    protected Progressable reporter;
    private Deserializer<KEYIN> keyDeserializer;
    private Deserializer<VALUEIN> valueDeserializer;
    private DataInputBuffer buffer = new DataInputBuffer();
    private BytesWritable currentRawKey = new BytesWritable();
    private ValueIterable iterable = new ValueIterable();

    public ReduceContext(Configuration conf, TaskAttemptID taskid, RawKeyValueIterator input, Counter inputKeyCounter, Counter inputValueCounter, RecordWriter<KEYOUT, VALUEOUT> output, OutputCommitter committer, StatusReporter reporter, RawComparator<KEYIN> comparator, Class<KEYIN> keyClass, Class<VALUEIN> valueClass) throws InterruptedException, IOException {
        super(conf, taskid, output, committer, reporter);
        this.input = input;
        this.inputKeyCounter = inputKeyCounter;
        this.inputValueCounter = inputValueCounter;
        this.comparator = comparator;
        SerializationFactory serializationFactory = new SerializationFactory(conf);
        this.keyDeserializer = serializationFactory.getDeserializer(keyClass);
        this.keyDeserializer.open(this.buffer);
        this.valueDeserializer = serializationFactory.getDeserializer(valueClass);
        this.valueDeserializer.open(this.buffer);
        this.hasMore = input.next();
    }

    public boolean nextKey() throws IOException, InterruptedException {
        while (this.hasMore && this.nextKeyIsSame) {
            this.nextKeyValue();
        }
        if (this.hasMore) {
            if (this.inputKeyCounter != null) {
                this.inputKeyCounter.increment(1L);
            }
            return this.nextKeyValue();
        }
        return false;
    }

    @Override
    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (!this.hasMore) {
            this.key = null;
            this.value = null;
            return false;
        }
        this.firstValue = !this.nextKeyIsSame;
        DataInputBuffer next = this.input.getKey();
        this.currentRawKey.set(next.getData(), next.getPosition(), next.getLength() - next.getPosition());
        this.buffer.reset(this.currentRawKey.getBytes(), 0, this.currentRawKey.getLength());
        this.key = this.keyDeserializer.deserialize(this.key);
        next = this.input.getValue();
        this.buffer.reset(next.getData(), next.getPosition(), next.getLength());
        this.value = this.valueDeserializer.deserialize(this.value);
        this.hasMore = this.input.next();
        if (this.hasMore) {
            next = this.input.getKey();
            this.nextKeyIsSame = this.comparator.compare(this.currentRawKey.getBytes(), 0, this.currentRawKey.getLength(), next.getData(), next.getPosition(), next.getLength() - next.getPosition()) == 0;
        } else {
            this.nextKeyIsSame = false;
        }
        this.inputValueCounter.increment(1L);
        return true;
    }

    @Override
    public KEYIN getCurrentKey() {
        return this.key;
    }

    @Override
    public VALUEIN getCurrentValue() {
        return this.value;
    }

    public Iterable<VALUEIN> getValues() throws IOException, InterruptedException {
        return this.iterable;
    }

    protected class ValueIterable
    implements Iterable<VALUEIN> {
        private ValueIterator iterator;

        protected ValueIterable() {
            this.iterator = new ValueIterator();
        }

        @Override
        public Iterator<VALUEIN> iterator() {
            return this.iterator;
        }
    }

    protected class ValueIterator
    implements Iterator<VALUEIN> {
        protected ValueIterator() {
        }

        @Override
        public boolean hasNext() {
            return ReduceContext.this.firstValue || ReduceContext.this.nextKeyIsSame;
        }

        @Override
        public VALUEIN next() {
            if (ReduceContext.this.firstValue) {
                ReduceContext.this.firstValue = false;
                return ReduceContext.this.value;
            }
            if (!ReduceContext.this.nextKeyIsSame) {
                throw new NoSuchElementException("iterate past last value");
            }
            try {
                ReduceContext.this.nextKeyValue();
                return ReduceContext.this.value;
            }
            catch (IOException ie) {
                throw new RuntimeException("next value iterator failed", ie);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException("next value iterator interrupted", ie);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not implemented");
        }
    }
}

