/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.pipes;

import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.FloatWritable;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.NullWritable;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.Writable;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.WritableComparable;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.Counters;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.OutputCollector;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.RecordReader;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.Reporter;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.pipes.PipesPartitioner;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.pipes.UpwardProtocol;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

class OutputHandler<K extends WritableComparable, V extends Writable>
implements UpwardProtocol<K, V> {
    private Reporter reporter;
    private OutputCollector<K, V> collector;
    private float progressValue = 0.0f;
    private boolean done = false;
    private Throwable exception = null;
    RecordReader<FloatWritable, NullWritable> recordReader = null;
    private Map<Integer, Counters.Counter> registeredCounters = new HashMap<Integer, Counters.Counter>();
    private FloatWritable progressKey = new FloatWritable(0.0f);
    private NullWritable nullValue = NullWritable.get();

    public OutputHandler(OutputCollector<K, V> collector, Reporter reporter, RecordReader<FloatWritable, NullWritable> recordReader) {
        this.reporter = reporter;
        this.collector = collector;
        this.recordReader = recordReader;
    }

    @Override
    public void output(K key, V value) throws IOException {
        this.collector.collect(key, value);
    }

    @Override
    public void partitionedOutput(int reduce, K key, V value) throws IOException {
        PipesPartitioner.setNextPartition(reduce);
        this.collector.collect(key, value);
    }

    @Override
    public void status(String msg) {
        this.reporter.setStatus(msg);
    }

    @Override
    public void progress(float progress) throws IOException {
        this.progressValue = progress;
        this.reporter.progress();
        if (this.recordReader != null) {
            this.progressKey.set(progress);
            this.recordReader.next(this.progressKey, this.nullValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void done() throws IOException {
        OutputHandler outputHandler = this;
        synchronized (outputHandler) {
            this.done = true;
            this.notify();
        }
    }

    public float getProgress() {
        return this.progressValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void failed(Throwable e) {
        OutputHandler outputHandler = this;
        synchronized (outputHandler) {
            this.exception = e;
            this.notify();
        }
    }

    public synchronized boolean waitForFinish() throws Throwable {
        while (!this.done && this.exception == null) {
            this.wait();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.done;
    }

    @Override
    public void registerCounter(int id, String group, String name) throws IOException {
        Counters.Counter counter = this.reporter.getCounter(group, name);
        this.registeredCounters.put(id, counter);
    }

    @Override
    public void incrementCounter(int id, long amount) throws IOException {
        if (id >= this.registeredCounters.size()) {
            throw new IOException("Invalid counter with id: " + id);
        }
        Counters.Counter counter = this.registeredCounters.get(id);
        counter.increment(amount);
    }
}

