/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.lib.aggregate;

import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.lib.aggregate.ValueAggregator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;

public class UniqValueCount
implements ValueAggregator {
    private TreeMap<Object, Object> uniqItems = null;
    private long numItems = 0L;
    private long maxNumItems = Long.MAX_VALUE;

    public UniqValueCount() {
        this(Long.MAX_VALUE);
    }

    public UniqValueCount(long maxNum) {
        this.uniqItems = new TreeMap();
        this.maxNumItems = Long.MAX_VALUE;
        if (maxNum > 0L) {
            this.maxNumItems = maxNum;
        }
    }

    public long setMaxItems(long n) {
        if (n >= this.numItems) {
            this.maxNumItems = n;
        } else if (this.maxNumItems >= this.numItems) {
            this.maxNumItems = this.numItems;
        }
        return this.maxNumItems;
    }

    @Override
    public void addNextValue(Object val) {
        if (this.numItems <= this.maxNumItems) {
            this.uniqItems.put(val.toString(), "1");
            this.numItems = this.uniqItems.size();
        }
    }

    @Override
    public String getReport() {
        return "" + this.uniqItems.size();
    }

    public Set getUniqueItems() {
        return this.uniqItems.keySet();
    }

    @Override
    public void reset() {
        this.uniqItems = new TreeMap();
    }

    @Override
    public ArrayList getCombinerOutput() {
        Object key = null;
        Iterator<Object> iter = this.uniqItems.keySet().iterator();
        ArrayList<Object> retv = new ArrayList<Object>();
        while (iter.hasNext()) {
            key = iter.next();
            retv.add(key);
        }
        return retv;
    }
}

