/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.lib.aggregate;

import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.lib.aggregate.ValueAggregator;
import java.util.ArrayList;

public class LongValueMin
implements ValueAggregator {
    long minVal = Long.MAX_VALUE;

    public LongValueMin() {
        this.reset();
    }

    @Override
    public void addNextValue(Object val) {
        long newVal = Long.parseLong(val.toString());
        if (this.minVal > newVal) {
            this.minVal = newVal;
        }
    }

    public void addNextValue(long newVal) {
        if (this.minVal > newVal) {
            this.minVal = newVal;
        }
    }

    public long getVal() {
        return this.minVal;
    }

    @Override
    public String getReport() {
        return "" + this.minVal;
    }

    @Override
    public void reset() {
        this.minVal = Long.MAX_VALUE;
    }

    @Override
    public ArrayList<String> getCombinerOutput() {
        ArrayList<String> retv = new ArrayList<String>(1);
        retv.add("" + this.minVal);
        return retv;
    }
}

