/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.lib;

import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.DataOutputBuffer;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.DefaultStringifier;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.serializer.Deserializer;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.serializer.Serialization;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.serializer.SerializationFactory;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.serializer.Serializer;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.JobConf;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.Mapper;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.OutputCollector;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.Reducer;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.Reporter;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.util.GenericsUtil;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.util.ReflectionUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class Chain {
    private static final String CHAIN_MAPPER = "chain.mapper";
    private static final String CHAIN_REDUCER = "chain.reducer";
    private static final String CHAIN_MAPPER_SIZE = ".size";
    private static final String CHAIN_MAPPER_CLASS = ".mapper.class.";
    private static final String CHAIN_MAPPER_CONFIG = ".mapper.config.";
    private static final String CHAIN_REDUCER_CLASS = ".reducer.class";
    private static final String CHAIN_REDUCER_CONFIG = ".reducer.config";
    private static final String MAPPER_BY_VALUE = "chain.mapper.byValue";
    private static final String REDUCER_BY_VALUE = "chain.reducer.byValue";
    private static final String MAPPER_INPUT_KEY_CLASS = "chain.mapper.input.key.class";
    private static final String MAPPER_INPUT_VALUE_CLASS = "chain.mapper.input.value.class";
    private static final String MAPPER_OUTPUT_KEY_CLASS = "chain.mapper.output.key.class";
    private static final String MAPPER_OUTPUT_VALUE_CLASS = "chain.mapper.output.value.class";
    private static final String REDUCER_INPUT_KEY_CLASS = "chain.reducer.input.key.class";
    private static final String REDUCER_INPUT_VALUE_CLASS = "chain.reducer.input.value.class";
    private static final String REDUCER_OUTPUT_KEY_CLASS = "chain.reducer.output.key.class";
    private static final String REDUCER_OUTPUT_VALUE_CLASS = "chain.reducer.output.value.class";
    private boolean isMap;
    private JobConf chainJobConf;
    private List<Mapper> mappers = new ArrayList<Mapper>();
    private Reducer reducer;
    private List<Serialization> mappersKeySerialization = new ArrayList<Serialization>();
    private List<Serialization> mappersValueSerialization = new ArrayList<Serialization>();
    private Serialization reducerKeySerialization;
    private Serialization reducerValueSerialization;
    private ThreadLocal<DataOutputBuffer> threadLocalDataOutputBuffer = new ThreadLocal<DataOutputBuffer>(){

        @Override
        protected DataOutputBuffer initialValue() {
            return new DataOutputBuffer(1024);
        }
    };

    Chain(boolean isMap) {
        this.isMap = isMap;
    }

    private static String getPrefix(boolean isMap) {
        return isMap ? CHAIN_MAPPER : CHAIN_REDUCER;
    }

    private static JobConf getChainElementConf(JobConf jobConf, String confKey) {
        JobConf conf;
        try {
            DefaultStringifier<JobConf> stringifier = new DefaultStringifier<JobConf>(jobConf, JobConf.class);
            conf = (JobConf)stringifier.fromString(jobConf.get(confKey, null));
        }
        catch (IOException ioex) {
            throw new RuntimeException(ioex);
        }
        jobConf = new JobConf(jobConf);
        for (Map.Entry<String, String> entry : conf) {
            jobConf.set(entry.getKey(), entry.getValue());
        }
        return jobConf;
    }

    public static <K1, V1, K2, V2> void addMapper(boolean isMap, JobConf jobConf, Class<? extends Mapper<K1, V1, K2, V2>> klass, Class<? extends K1> inputKeyClass, Class<? extends V1> inputValueClass, Class<? extends K2> outputKeyClass, Class<? extends V2> outputValueClass, boolean byValue, JobConf mapperConf) {
        String prefix = Chain.getPrefix(isMap);
        if (!isMap && jobConf.getClass(prefix + CHAIN_REDUCER_CLASS, Reducer.class) == null) {
            throw new IllegalStateException("A Mapper can be added to the chain only after the Reducer has been set");
        }
        int index = jobConf.getInt(prefix + CHAIN_MAPPER_SIZE, 0);
        jobConf.setClass(prefix + CHAIN_MAPPER_CLASS + index, klass, Mapper.class);
        if (!isMap && index == 0) {
            JobConf reducerConf = Chain.getChainElementConf(jobConf, prefix + CHAIN_REDUCER_CONFIG);
            if (!inputKeyClass.isAssignableFrom(reducerConf.getClass(REDUCER_OUTPUT_KEY_CLASS, null))) {
                throw new IllegalArgumentException("The Reducer output key class does not match the Mapper input key class");
            }
            if (!inputValueClass.isAssignableFrom(reducerConf.getClass(REDUCER_OUTPUT_VALUE_CLASS, null))) {
                throw new IllegalArgumentException("The Reducer output value class does not match the Mapper input value class");
            }
        } else if (index > 0) {
            JobConf previousMapperConf = Chain.getChainElementConf(jobConf, prefix + CHAIN_MAPPER_CONFIG + (index - 1));
            if (!inputKeyClass.isAssignableFrom(previousMapperConf.getClass(MAPPER_OUTPUT_KEY_CLASS, null))) {
                throw new IllegalArgumentException("The Mapper output key class does not match the previous Mapper input key class");
            }
            if (!inputValueClass.isAssignableFrom(previousMapperConf.getClass(MAPPER_OUTPUT_VALUE_CLASS, null))) {
                throw new IllegalArgumentException("The Mapper output value class does not match the previous Mapper input value class");
            }
        }
        if (mapperConf == null) {
            mapperConf = new JobConf(true);
        }
        mapperConf.setBoolean(MAPPER_BY_VALUE, byValue);
        mapperConf.setClass(MAPPER_INPUT_KEY_CLASS, inputKeyClass, Object.class);
        mapperConf.setClass(MAPPER_INPUT_VALUE_CLASS, inputValueClass, Object.class);
        mapperConf.setClass(MAPPER_OUTPUT_KEY_CLASS, outputKeyClass, Object.class);
        mapperConf.setClass(MAPPER_OUTPUT_VALUE_CLASS, outputValueClass, Object.class);
        DefaultStringifier<JobConf> stringifier = new DefaultStringifier<JobConf>(jobConf, JobConf.class);
        try {
            jobConf.set(prefix + CHAIN_MAPPER_CONFIG + index, stringifier.toString(new JobConf(mapperConf)));
        }
        catch (IOException ioEx) {
            throw new RuntimeException(ioEx);
        }
        jobConf.setInt(prefix + CHAIN_MAPPER_SIZE, index + 1);
    }

    public static <K1, V1, K2, V2> void setReducer(JobConf jobConf, Class<? extends Reducer<K1, V1, K2, V2>> klass, Class<? extends K1> inputKeyClass, Class<? extends V1> inputValueClass, Class<? extends K2> outputKeyClass, Class<? extends V2> outputValueClass, boolean byValue, JobConf reducerConf) {
        String prefix = Chain.getPrefix(false);
        if (jobConf.getClass(prefix + CHAIN_REDUCER_CLASS, null) != null) {
            throw new IllegalStateException("Reducer has been already set");
        }
        jobConf.setClass(prefix + CHAIN_REDUCER_CLASS, klass, Reducer.class);
        if (reducerConf == null) {
            reducerConf = new JobConf(false);
        }
        reducerConf.setBoolean(MAPPER_BY_VALUE, byValue);
        reducerConf.setClass(REDUCER_INPUT_KEY_CLASS, inputKeyClass, Object.class);
        reducerConf.setClass(REDUCER_INPUT_VALUE_CLASS, inputValueClass, Object.class);
        reducerConf.setClass(REDUCER_OUTPUT_KEY_CLASS, outputKeyClass, Object.class);
        reducerConf.setClass(REDUCER_OUTPUT_VALUE_CLASS, outputValueClass, Object.class);
        DefaultStringifier<JobConf> stringifier = new DefaultStringifier<JobConf>(jobConf, JobConf.class);
        try {
            jobConf.set(prefix + CHAIN_REDUCER_CONFIG, stringifier.toString(new JobConf(reducerConf)));
        }
        catch (IOException ioEx) {
            throw new RuntimeException(ioEx);
        }
    }

    public void configure(JobConf jobConf) {
        String prefix = Chain.getPrefix(this.isMap);
        this.chainJobConf = jobConf;
        SerializationFactory serializationFactory = new SerializationFactory(this.chainJobConf);
        int index = jobConf.getInt(prefix + CHAIN_MAPPER_SIZE, 0);
        for (int i = 0; i < index; ++i) {
            Class<Mapper> klass = jobConf.getClass(prefix + CHAIN_MAPPER_CLASS + i, null, Mapper.class);
            JobConf mConf = Chain.getChainElementConf(jobConf, prefix + CHAIN_MAPPER_CONFIG + i);
            Mapper mapper = ReflectionUtils.newInstance(klass, mConf);
            this.mappers.add(mapper);
            if (mConf.getBoolean(MAPPER_BY_VALUE, true)) {
                this.mappersKeySerialization.add(serializationFactory.getSerialization(mConf.getClass(MAPPER_OUTPUT_KEY_CLASS, null)));
                this.mappersValueSerialization.add(serializationFactory.getSerialization(mConf.getClass(MAPPER_OUTPUT_VALUE_CLASS, null)));
                continue;
            }
            this.mappersKeySerialization.add(null);
            this.mappersValueSerialization.add(null);
        }
        Class<Reducer> klass = jobConf.getClass(prefix + CHAIN_REDUCER_CLASS, null, Reducer.class);
        if (klass != null) {
            JobConf rConf = Chain.getChainElementConf(jobConf, prefix + CHAIN_REDUCER_CONFIG);
            this.reducer = ReflectionUtils.newInstance(klass, rConf);
            if (rConf.getBoolean(REDUCER_BY_VALUE, true)) {
                this.reducerKeySerialization = serializationFactory.getSerialization(rConf.getClass(REDUCER_OUTPUT_KEY_CLASS, null));
                this.reducerValueSerialization = serializationFactory.getSerialization(rConf.getClass(REDUCER_OUTPUT_VALUE_CLASS, null));
            } else {
                this.reducerKeySerialization = null;
                this.reducerValueSerialization = null;
            }
        }
    }

    protected JobConf getChainJobConf() {
        return this.chainJobConf;
    }

    public Mapper getFirstMap() {
        return this.mappers.size() > 0 ? this.mappers.get(0) : null;
    }

    public Reducer getReducer() {
        return this.reducer;
    }

    public OutputCollector getMapperCollector(int mapperIndex, OutputCollector output, Reporter reporter) {
        Serialization keySerialization = this.mappersKeySerialization.get(mapperIndex);
        Serialization valueSerialization = this.mappersValueSerialization.get(mapperIndex);
        return new ChainOutputCollector(mapperIndex, keySerialization, valueSerialization, output, reporter);
    }

    public OutputCollector getReducerCollector(OutputCollector output, Reporter reporter) {
        return new ChainOutputCollector(this.reducerKeySerialization, this.reducerValueSerialization, output, reporter);
    }

    public void close() throws IOException {
        for (Mapper map : this.mappers) {
            map.close();
        }
        if (this.reducer != null) {
            this.reducer.close();
        }
    }

    private class ChainOutputCollector<K, V>
    implements OutputCollector<K, V> {
        private int nextMapperIndex;
        private Serialization<K> keySerialization;
        private Serialization<V> valueSerialization;
        private OutputCollector output;
        private Reporter reporter;

        public ChainOutputCollector(int index, Serialization<K> keySerialization, Serialization<V> valueSerialization, OutputCollector output, Reporter reporter) {
            this.nextMapperIndex = index + 1;
            this.keySerialization = keySerialization;
            this.valueSerialization = valueSerialization;
            this.output = output;
            this.reporter = reporter;
        }

        public ChainOutputCollector(Serialization<K> keySerialization, Serialization<V> valueSerialization, OutputCollector output, Reporter reporter) {
            this.nextMapperIndex = 0;
            this.keySerialization = keySerialization;
            this.valueSerialization = valueSerialization;
            this.output = output;
            this.reporter = reporter;
        }

        @Override
        public void collect(K key, V value) throws IOException {
            if (this.nextMapperIndex < Chain.this.mappers.size()) {
                if (this.keySerialization != null) {
                    key = this.makeCopyForPassByValue(this.keySerialization, key);
                    value = this.makeCopyForPassByValue(this.valueSerialization, value);
                }
                Serialization nextKeySerialization = (Serialization)Chain.this.mappersKeySerialization.get(this.nextMapperIndex);
                Serialization nextValueSerialization = (Serialization)Chain.this.mappersValueSerialization.get(this.nextMapperIndex);
                Mapper nextMapper = (Mapper)Chain.this.mappers.get(this.nextMapperIndex);
                nextMapper.map(key, value, new ChainOutputCollector<K, V>(this.nextMapperIndex, nextKeySerialization, nextValueSerialization, this.output, this.reporter), this.reporter);
            } else {
                this.output.collect(key, value);
            }
        }

        private <E> E makeCopyForPassByValue(Serialization<E> serialization, E obj) throws IOException {
            Serializer<E> ser = serialization.getSerializer(GenericsUtil.getClass(obj));
            Deserializer<E> deser = serialization.getDeserializer(GenericsUtil.getClass(obj));
            DataOutputBuffer dof = (DataOutputBuffer)Chain.this.threadLocalDataOutputBuffer.get();
            dof.reset();
            ser.open(dof);
            ser.serialize(obj);
            ser.close();
            obj = ReflectionUtils.newInstance(GenericsUtil.getClass(obj), Chain.this.getChainJobConf());
            ByteArrayInputStream bais = new ByteArrayInputStream(dof.getData(), 0, dof.getLength());
            deser.open(bais);
            deser.deserialize(obj);
            deser.close();
            return obj;
        }
    }
}

