/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.join;

import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.Writable;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.WritableComparable;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.WritableComparator;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.WritableUtils;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.JobConf;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.join.ComposableRecordReader;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.join.CompositeRecordReader;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.join.ResetableIterator;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.join.TupleWritable;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.util.ReflectionUtils;
import java.io.IOException;
import java.util.PriorityQueue;

public abstract class MultiFilterRecordReader<K extends WritableComparable, V extends Writable>
extends CompositeRecordReader<K, V, V>
implements ComposableRecordReader<K, V> {
    private Class<? extends Writable> valueclass;
    private TupleWritable ivalue;

    public MultiFilterRecordReader(int id, JobConf conf, int capacity, Class<? extends WritableComparator> cmpcl) throws IOException {
        super(id, capacity, cmpcl);
        this.setConf(conf);
    }

    protected abstract V emit(TupleWritable var1) throws IOException;

    @Override
    protected boolean combine(Object[] srcs, TupleWritable dst) {
        return true;
    }

    @Override
    public boolean next(K key, V value) throws IOException {
        if (this.jc.flush(this.ivalue)) {
            WritableUtils.cloneInto(key, this.jc.key());
            WritableUtils.cloneInto(value, this.emit(this.ivalue));
            return true;
        }
        this.jc.clear();
        Object iterkey = this.createKey();
        PriorityQueue q = this.getRecordReaderQueue();
        while (!q.isEmpty()) {
            this.fillJoinCollector(iterkey);
            this.jc.reset(iterkey);
            if (this.jc.flush(this.ivalue)) {
                WritableUtils.cloneInto(key, this.jc.key());
                WritableUtils.cloneInto(value, this.emit(this.ivalue));
                return true;
            }
            this.jc.clear();
        }
        return false;
    }

    @Override
    public V createValue() {
        if (null == this.valueclass) {
            Class<?> cls = ((Writable)this.kids[0].createValue()).getClass();
            for (ComposableRecordReader rr : this.kids) {
                if (cls.equals(((Writable)rr.createValue()).getClass())) continue;
                throw new ClassCastException("Child value classes fail to agree");
            }
            this.valueclass = cls.asSubclass(Writable.class);
            this.ivalue = this.createInternalValue();
        }
        return (V)ReflectionUtils.newInstance(this.valueclass, null);
    }

    @Override
    protected ResetableIterator<V> getDelegate() {
        return new MultiFilterDelegationIterator();
    }

    protected class MultiFilterDelegationIterator
    implements ResetableIterator<V> {
        protected MultiFilterDelegationIterator() {
        }

        @Override
        public boolean hasNext() {
            return MultiFilterRecordReader.this.jc.hasNext();
        }

        @Override
        public boolean next(V val) throws IOException {
            boolean ret = MultiFilterRecordReader.this.jc.flush(MultiFilterRecordReader.this.ivalue);
            if (ret) {
                WritableUtils.cloneInto(val, MultiFilterRecordReader.this.emit(MultiFilterRecordReader.this.ivalue));
            }
            return ret;
        }

        @Override
        public boolean replay(V val) throws IOException {
            WritableUtils.cloneInto(val, MultiFilterRecordReader.this.emit(MultiFilterRecordReader.this.ivalue));
            return true;
        }

        @Override
        public void reset() {
            MultiFilterRecordReader.this.jc.reset(MultiFilterRecordReader.this.jc.key());
        }

        @Override
        public void add(V item) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
            MultiFilterRecordReader.this.jc.close();
        }

        @Override
        public void clear() {
            MultiFilterRecordReader.this.jc.clear();
        }
    }
}

