/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.join;

import io.prestosql.hive.jdbc.;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.Path;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.WritableComparable;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.InputFormat;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.InputSplit;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.JobConf;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.Reporter;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.join.ComposableInputFormat;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.join.ComposableRecordReader;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.join.Parser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CompositeInputFormat<K extends WritableComparable>
implements ComposableInputFormat<K, .TupleWritable> {
    private Parser.Node root;

    public void setFormat(JobConf job) throws IOException {
        this.addDefaults();
        this.addUserIdentifiers(job);
        this.root = Parser.parse(job.get("mapred.join.expr", null), job);
    }

    protected void addDefaults() {
        try {
            Parser.CNode.addIdentifier("inner", .InnerJoinRecordReader.class);
            Parser.CNode.addIdentifier("outer", .OuterJoinRecordReader.class);
            Parser.CNode.addIdentifier("override", .OverrideRecordReader.class);
            Parser.WNode.addIdentifier("tbl", .WrappedRecordReader.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("FATAL: Failed to init defaults", e);
        }
    }

    private void addUserIdentifiers(JobConf job) throws IOException {
        Pattern x = Pattern.compile("^mapred\\.join\\.define\\.(\\w+)$");
        for (Map.Entry<String, String> kv : job) {
            Matcher m = x.matcher(kv.getKey());
            if (!m.matches()) continue;
            try {
                Parser.CNode.addIdentifier(m.group(1), job.getClass(m.group(0), null, ComposableRecordReader.class));
            }
            catch (NoSuchMethodException e) {
                throw (IOException)new IOException("Invalid define for " + m.group(1)).initCause(e);
            }
        }
    }

    @Override
    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        this.setFormat(job);
        job.setLong("mapred.min.split.size", Long.MAX_VALUE);
        return this.root.getSplits(job, numSplits);
    }

    @Override
    public ComposableRecordReader<K, .TupleWritable> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        this.setFormat(job);
        return this.root.getRecordReader(split, job, reporter);
    }

    public static String compose(Class<? extends InputFormat> inf, String path) {
        return CompositeInputFormat.compose(inf.getName().intern(), path, new StringBuffer()).toString();
    }

    public static String compose(String op, Class<? extends InputFormat> inf, String ... path) {
        String infname = inf.getName();
        StringBuffer ret = new StringBuffer(op + '(');
        for (String p : path) {
            CompositeInputFormat.compose(infname, p, ret);
            ret.append(',');
        }
        ret.setCharAt(ret.length() - 1, ')');
        return ret.toString();
    }

    public static String compose(String op, Class<? extends InputFormat> inf, Path ... path) {
        ArrayList<String> tmp = new ArrayList<String>(path.length);
        for (Path p : path) {
            tmp.add(p.toString());
        }
        return CompositeInputFormat.compose(op, inf, tmp.toArray(new String[0]));
    }

    private static StringBuffer compose(String inf, String path, StringBuffer sb) {
        sb.append("tbl(" + inf + ",\"");
        sb.append(path);
        sb.append("\")");
        return sb;
    }
}

