/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred;

import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.Writable;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.WritableUtils;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.CommitTaskAction;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.KillJobAction;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.KillTaskAction;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.LaunchTaskAction;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.ReinitTrackerAction;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

abstract class TaskTrackerAction
implements Writable {
    private ActionType actionType;

    public static TaskTrackerAction createAction(ActionType actionType) {
        TaskTrackerAction action = null;
        switch (actionType) {
            case LAUNCH_TASK: {
                action = new LaunchTaskAction();
                break;
            }
            case KILL_TASK: {
                action = new KillTaskAction();
                break;
            }
            case KILL_JOB: {
                action = new KillJobAction();
                break;
            }
            case REINIT_TRACKER: {
                action = new ReinitTrackerAction();
                break;
            }
            case COMMIT_TASK: {
                action = new CommitTaskAction();
            }
        }
        return action;
    }

    protected TaskTrackerAction(ActionType actionType) {
        this.actionType = actionType;
    }

    ActionType getActionId() {
        return this.actionType;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        WritableUtils.writeEnum(out, this.actionType);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.actionType = WritableUtils.readEnum(in, ActionType.class);
    }

    public static enum ActionType {
        LAUNCH_TASK,
        KILL_TASK,
        KILL_JOB,
        REINIT_TRACKER,
        COMMIT_TASK;

    }
}

