/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred;

import io.prestosql.hive.jdbc.$internal.org.apache.commons.logging.Log;
import io.prestosql.hive.jdbc.$internal.org.apache.commons.logging.LogFactory;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.filecache.DistributedCache;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.FSDataOutputStream;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.FSError;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.FileStatus;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.FileSystem;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.FileUtil;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.LocalDirAllocator;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.LocalFileSystem;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.Path;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.Child;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.JobConf;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.JvmManager;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.MapOutputFile;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.Task;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.TaskAttemptID;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.TaskLog;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.TaskTracker;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.util.Shell;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

abstract class TaskRunner
extends Thread {
    public static final Log LOG = LogFactory.getLog(TaskRunner.class);
    volatile boolean killed = false;
    private TaskTracker.TaskInProgress tip;
    private Task t;
    private Object lock = new Object();
    private volatile boolean done = false;
    private int exitCode = -1;
    private boolean exitCodeSet = false;
    private TaskTracker tracker;
    protected JobConf conf;
    JvmManager jvmManager;
    protected MapOutputFile mapOutputFile;

    public TaskRunner(TaskTracker.TaskInProgress tip, TaskTracker tracker, JobConf conf) {
        this.tip = tip;
        this.t = tip.getTask();
        this.tracker = tracker;
        this.conf = conf;
        this.mapOutputFile = new MapOutputFile(this.t.getJobID());
        this.mapOutputFile.setConf(conf);
        this.jvmManager = tracker.getJvmManagerInstance();
    }

    public Task getTask() {
        return this.t;
    }

    public TaskTracker.TaskInProgress getTaskInProgress() {
        return this.tip;
    }

    public TaskTracker getTracker() {
        return this.tracker;
    }

    public boolean prepare() throws IOException {
        return true;
    }

    public void close() throws IOException {
    }

    private static String stringifyPathArray(Path[] p) {
        if (p == null) {
            return null;
        }
        StringBuffer str = new StringBuffer(p[0].toString());
        for (int i = 1; i < p.length; ++i) {
            str.append(",");
            str.append(p[i].toString());
        }
        return str.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public final void run() {
        block77: {
            URI[] files;
            block76: {
                LocalFileSystem localFs;
                int i;
                Path[] localFiles;
                Path[] fileClasspaths;
                Path[] localArchives;
                Path[] archiveClasspaths;
                String jar;
                URI[] files2;
                URI[] archives;
                File workDir;
                File jobCacheDir;
                LocalDirAllocator lDirAlloc;
                TaskAttemptID taskid;
                block75: {
                    taskid = this.t.getTaskID();
                    lDirAlloc = new LocalDirAllocator("mapred.local.dir");
                    jobCacheDir = null;
                    if (this.conf.getJar() != null) {
                        jobCacheDir = new File(new Path(this.conf.getJar()).getParent().toString());
                    }
                    workDir = new File(lDirAlloc.getLocalPathToRead(TaskTracker.getLocalTaskDir(this.t.getJobID().toString(), this.t.getTaskID().toString(), this.t.isTaskCleanupTask()) + "/" + "work", this.conf).toString());
                    archives = DistributedCache.getCacheArchives(this.conf);
                    files2 = DistributedCache.getCacheFiles(this.conf);
                    if (archives != null || files2 != null) {
                        String baseDir;
                        Path localPath;
                        String cachePath;
                        String cacheId;
                        FileStatus fileStatus;
                        FileSystem fileSystem;
                        int i2;
                        Path[] p;
                        if (archives != null) {
                            String[] archivesTimestamps = DistributedCache.getArchiveTimestamps(this.conf);
                            p = new Path[archives.length];
                            for (i2 = 0; i2 < archives.length; ++i2) {
                                fileSystem = FileSystem.get(archives[i2], this.conf);
                                fileStatus = fileSystem.getFileStatus(new Path(archives[i2].getPath()));
                                cacheId = DistributedCache.makeRelative(archives[i2], this.conf);
                                cachePath = TaskTracker.getCacheSubdir() + "/" + cacheId;
                                localPath = lDirAlloc.getLocalPathForWrite(cachePath, fileStatus.getLen(), this.conf);
                                baseDir = localPath.toString().replace(cacheId, "");
                                p[i2] = DistributedCache.getLocalCache(archives[i2], this.conf, new Path(baseDir), fileStatus, true, Long.parseLong(archivesTimestamps[i2]), new Path(workDir.getAbsolutePath()), false);
                            }
                            DistributedCache.setLocalArchives(this.conf, TaskRunner.stringifyPathArray(p));
                        }
                        if (files2 != null) {
                            String[] fileTimestamps = DistributedCache.getFileTimestamps(this.conf);
                            p = new Path[files2.length];
                            for (i2 = 0; i2 < files2.length; ++i2) {
                                fileSystem = FileSystem.get(files2[i2], this.conf);
                                fileStatus = fileSystem.getFileStatus(new Path(files2[i2].getPath()));
                                cacheId = DistributedCache.makeRelative(files2[i2], this.conf);
                                cachePath = TaskTracker.getCacheSubdir() + "/" + cacheId;
                                localPath = lDirAlloc.getLocalPathForWrite(cachePath, fileStatus.getLen(), this.conf);
                                baseDir = localPath.toString().replace(cacheId, "");
                                p[i2] = DistributedCache.getLocalCache(files2[i2], this.conf, new Path(baseDir), fileStatus, false, Long.parseLong(fileTimestamps[i2]), new Path(workDir.getAbsolutePath()), false);
                            }
                            DistributedCache.setLocalFiles(this.conf, TaskRunner.stringifyPathArray(p));
                        }
                        Path localTaskFile = new Path(this.t.getJobFile());
                        LocalFileSystem localFs2 = FileSystem.getLocal(this.conf);
                        ((FileSystem)localFs2).delete(localTaskFile, true);
                        FSDataOutputStream out = localFs2.create(localTaskFile);
                        try {
                            this.conf.writeXml(out);
                        }
                        finally {
                            ((OutputStream)out).close();
                        }
                    }
                    if (this.prepare()) break block75;
                    try {
                        URI[] archives2 = DistributedCache.getCacheArchives(this.conf);
                        URI[] files3 = DistributedCache.getCacheFiles(this.conf);
                        if (archives2 != null) {
                            for (int i3 = 0; i3 < archives2.length; ++i3) {
                                DistributedCache.releaseCache(archives2[i3], this.conf);
                            }
                        }
                        if (files3 != null) {
                            for (int i4 = 0; i4 < files3.length; ++i4) {
                                DistributedCache.releaseCache(files3[i4], this.conf);
                            }
                        }
                    }
                    catch (IOException ie) {
                        LOG.warn("Error releasing caches : Cache files might not have been cleaned up");
                    }
                    this.tip.reportTaskFinished();
                    return;
                }
                String sep = System.getProperty("path.separator");
                StringBuffer classPath = new StringBuffer();
                classPath.append(System.getProperty("java.class.path"));
                classPath.append(sep);
                if (!workDir.mkdirs() && !workDir.isDirectory()) {
                    LOG.fatal("Mkdirs failed to create " + workDir.toString());
                }
                if ((jar = this.conf.getJar()) != null) {
                    File[] libs = new File(jobCacheDir, "lib").listFiles();
                    if (libs != null) {
                        for (int i5 = 0; i5 < libs.length; ++i5) {
                            classPath.append(sep);
                            classPath.append(libs[i5]);
                        }
                    }
                    classPath.append(sep);
                    classPath.append(new File(jobCacheDir, "classes"));
                    classPath.append(sep);
                    classPath.append(jobCacheDir);
                }
                if ((archiveClasspaths = DistributedCache.getArchiveClassPaths(this.conf)) != null && archives != null && (localArchives = DistributedCache.getLocalCacheArchives(this.conf)) != null) {
                    for (int i6 = 0; i6 < archives.length; ++i6) {
                        for (int j = 0; j < archiveClasspaths.length; ++j) {
                            if (!archives[i6].getPath().equals(archiveClasspaths[j].toString())) continue;
                            classPath.append(sep);
                            classPath.append(localArchives[i6].toString());
                        }
                    }
                }
                if ((fileClasspaths = DistributedCache.getFileClassPaths(this.conf)) != null && files2 != null && (localFiles = DistributedCache.getLocalCacheFiles(this.conf)) != null) {
                    for (int i7 = 0; i7 < files2.length; ++i7) {
                        for (int j = 0; j < fileClasspaths.length; ++j) {
                            if (!files2[i7].getPath().equals(fileClasspaths[j].toString())) continue;
                            classPath.append(sep);
                            classPath.append(localFiles[i7].toString());
                        }
                    }
                }
                classPath.append(sep);
                classPath.append(workDir);
                Vector<String> vargs = new Vector<String>(8);
                File jvm = new File(new File(System.getProperty("java.home"), "bin"), "java");
                vargs.add(jvm.toString());
                String javaOpts = this.conf.get("mapred.child.java.opts", "-Xmx200m");
                javaOpts = javaOpts.replace("@taskid@", taskid.toString());
                String[] javaOptsSplit = javaOpts.split(" ");
                String libraryPath = System.getProperty("java.library.path");
                libraryPath = libraryPath == null ? workDir.getAbsolutePath() : libraryPath + sep + workDir;
                boolean hasUserLDPath = false;
                for (i = 0; i < javaOptsSplit.length; ++i) {
                    if (!javaOptsSplit[i].startsWith("-Djava.library.path=")) continue;
                    int n = i;
                    javaOptsSplit[n] = javaOptsSplit[n] + sep + libraryPath;
                    hasUserLDPath = true;
                    break;
                }
                if (!hasUserLDPath) {
                    vargs.add("-Djava.library.path=" + libraryPath);
                }
                for (i = 0; i < javaOptsSplit.length; ++i) {
                    vargs.add(javaOptsSplit[i]);
                }
                String tmp = this.conf.get("mapred.child.tmp", "./tmp");
                Path tmpDir = new Path(tmp);
                if (!tmpDir.isAbsolute()) {
                    tmpDir = new Path(workDir.toString(), tmp);
                }
                if (!((FileSystem)(localFs = FileSystem.getLocal(this.conf))).mkdirs(tmpDir) && !((FileSystem)localFs).getFileStatus(tmpDir).isDir()) {
                    throw new IOException("Mkdirs failed to create " + tmpDir.toString());
                }
                vargs.add("-Djava.io.tmpdir=" + tmpDir.toString());
                vargs.add("-classpath");
                vargs.add(classPath.toString());
                long logSize = TaskLog.getTaskLogLength(this.conf);
                vargs.add("-Dhadoop.log.dir=" + new File(System.getProperty("hadoop.log.dir")).getAbsolutePath());
                vargs.add("-Dhadoop.root.logger=INFO,TLA");
                vargs.add("-Dhadoop.tasklog.taskid=" + taskid);
                vargs.add("-Dhadoop.tasklog.totalLogFileSize=" + logSize);
                if (this.conf.getProfileEnabled() && this.conf.getProfileTaskRange(this.t.isMapTask()).isIncluded(this.t.getPartition())) {
                    File prof = TaskLog.getTaskLogFile(taskid, TaskLog.LogName.PROFILE);
                    vargs.add(String.format(this.conf.getProfileParams(), prof.toString()));
                }
                vargs.add(Child.class.getName());
                InetSocketAddress address = this.tracker.getTaskTrackerReportAddress();
                vargs.add(address.getAddress().getHostAddress());
                vargs.add(Integer.toString(address.getPort()));
                vargs.add(taskid.toString());
                String pidFile = lDirAlloc.getLocalPathForWrite(TaskTracker.getPidFile(this.t.getJobID().toString(), taskid.toString(), this.t.isTaskCleanupTask()), this.conf).toString();
                this.t.setPidFile(pidFile);
                this.tracker.addToMemoryManager(this.t.getTaskID(), this.t.isMapTask(), this.conf, pidFile);
                String[] ulimitCmd = Shell.getUlimitMemoryCommand(this.conf);
                ArrayList<String> setup = null;
                if (ulimitCmd != null) {
                    setup = new ArrayList<String>();
                    for (String arg : ulimitCmd) {
                        setup.add(arg);
                    }
                }
                File stdout = TaskLog.getTaskLogFile(taskid, TaskLog.LogName.STDOUT);
                File stderr = TaskLog.getTaskLogFile(taskid, TaskLog.LogName.STDERR);
                stdout.getParentFile().mkdirs();
                this.tracker.getTaskTrackerInstrumentation().reportTaskLaunch(taskid, stdout, stderr);
                HashMap<String, String> env = new HashMap<String, String>();
                StringBuffer ldLibraryPath = new StringBuffer();
                ldLibraryPath.append(workDir.toString());
                String oldLdLibraryPath = null;
                oldLdLibraryPath = System.getenv("LD_LIBRARY_PATH");
                if (oldLdLibraryPath != null) {
                    ldLibraryPath.append(sep);
                    ldLibraryPath.append(oldLdLibraryPath);
                }
                env.put("LD_LIBRARY_PATH", ldLibraryPath.toString());
                this.jvmManager.launchJvm(this, this.jvmManager.constructJvmEnv(setup, vargs, stdout, stderr, logSize, workDir, env, pidFile, this.conf));
                Object object = this.lock;
                synchronized (object) {
                    while (!this.done) {
                        this.lock.wait();
                    }
                }
                this.tracker.getTaskTrackerInstrumentation().reportTaskEnd(this.t.getTaskID());
                if (!this.exitCodeSet || this.killed || this.exitCode == 0) break block76;
                if (this.exitCode == 65) {
                    this.tracker.getTaskTrackerInstrumentation().taskFailedPing(this.t.getTaskID());
                }
                throw new IOException("Task process exit with nonzero status of " + this.exitCode + ".");
            }
            try {
                URI[] archives = DistributedCache.getCacheArchives(this.conf);
                files = DistributedCache.getCacheFiles(this.conf);
                if (archives != null) {
                    for (int i = 0; i < archives.length; ++i) {
                        DistributedCache.releaseCache(archives[i], this.conf);
                    }
                }
                if (files != null) {
                    for (int i = 0; i < files.length; ++i) {
                        DistributedCache.releaseCache(files[i], this.conf);
                    }
                }
            }
            catch (IOException ie) {
                LOG.warn("Error releasing caches : Cache files might not have been cleaned up");
            }
            this.tip.reportTaskFinished();
            break block77;
            catch (FSError e) {
                LOG.fatal("FSError", e);
                try {
                    this.tracker.fsError(this.t.getTaskID(), e.getMessage());
                }
                catch (IOException ie) {
                    LOG.fatal(this.t.getTaskID() + " reporting FSError", ie);
                }
                try {
                    URI[] archives = DistributedCache.getCacheArchives(this.conf);
                    files = DistributedCache.getCacheFiles(this.conf);
                    if (archives != null) {
                        for (int i = 0; i < archives.length; ++i) {
                            DistributedCache.releaseCache(archives[i], this.conf);
                        }
                    }
                    if (files != null) {
                        for (int i = 0; i < files.length; ++i) {
                            DistributedCache.releaseCache(files[i], this.conf);
                        }
                    }
                }
                catch (IOException ie) {
                    LOG.warn("Error releasing caches : Cache files might not have been cleaned up");
                }
                this.tip.reportTaskFinished();
                break block77;
            }
            catch (Throwable throwable) {
                LOG.warn(this.t.getTaskID() + " Child Error", throwable);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                throwable.printStackTrace(new PrintStream(baos));
                try {
                    this.tracker.reportDiagnosticInfo(this.t.getTaskID(), baos.toString());
                }
                catch (IOException e2) {
                    LOG.warn(this.t.getTaskID() + " Reporting Diagnostics", e2);
                }
                try {
                    URI[] archives = DistributedCache.getCacheArchives(this.conf);
                    files = DistributedCache.getCacheFiles(this.conf);
                    if (archives != null) {
                        for (int i = 0; i < archives.length; ++i) {
                            DistributedCache.releaseCache(archives[i], this.conf);
                        }
                    }
                    if (files != null) {
                        for (int i = 0; i < files.length; ++i) {
                            DistributedCache.releaseCache(files[i], this.conf);
                        }
                    }
                }
                catch (IOException ie) {
                    LOG.warn("Error releasing caches : Cache files might not have been cleaned up");
                }
                this.tip.reportTaskFinished();
                break block77;
                {
                    catch (Throwable throwable2) {
                        try {
                            int i;
                            URI[] archives = DistributedCache.getCacheArchives(this.conf);
                            URI[] files4 = DistributedCache.getCacheFiles(this.conf);
                            if (archives != null) {
                                for (i = 0; i < archives.length; ++i) {
                                    DistributedCache.releaseCache(archives[i], this.conf);
                                }
                            }
                            if (files4 != null) {
                                for (i = 0; i < files4.length; ++i) {
                                    DistributedCache.releaseCache(files4[i], this.conf);
                                }
                            }
                        }
                        catch (IOException ie) {
                            LOG.warn("Error releasing caches : Cache files might not have been cleaned up");
                        }
                        this.tip.reportTaskFinished();
                        throw throwable2;
                    }
                }
            }
        }
    }

    public static void setupWorkDir(JobConf conf) throws IOException {
        File workDir = new File(".").getAbsoluteFile();
        FileUtil.fullyDelete(workDir);
        if (DistributedCache.getSymlink(conf)) {
            File flink;
            String link;
            int i;
            URI[] archives = DistributedCache.getCacheArchives(conf);
            URI[] files = DistributedCache.getCacheFiles(conf);
            Path[] localArchives = DistributedCache.getLocalCacheArchives(conf);
            Path[] localFiles = DistributedCache.getLocalCacheFiles(conf);
            if (archives != null) {
                for (i = 0; i < archives.length; ++i) {
                    link = archives[i].getFragment();
                    if (link == null || (flink = new File(link = workDir.toString() + "/" + link)).exists()) continue;
                    FileUtil.symLink(localArchives[i].toString(), link);
                }
            }
            if (files != null) {
                for (i = 0; i < files.length; ++i) {
                    link = files[i].getFragment();
                    if (link == null || (flink = new File(link = workDir.toString() + "/" + link)).exists()) continue;
                    FileUtil.symLink(localFiles[i].toString(), link);
                }
            }
        }
        File jobCacheDir = null;
        if (conf.getJar() != null) {
            jobCacheDir = new File(new Path(conf.getJar()).getParent().toString());
        }
        try {
            DistributedCache.createAllSymlink(conf, jobCacheDir, workDir);
        }
        catch (IOException ie) {
            LOG.warn(StringUtils.stringifyException(ie));
        }
        String tmp = conf.get("mapred.child.tmp", "./tmp");
        Path tmpDir = new Path(tmp);
        if (!tmpDir.isAbsolute()) {
            tmpDir = new Path(workDir.toString(), tmp);
            LocalFileSystem localFs = FileSystem.getLocal(conf);
            if (!((FileSystem)localFs).mkdirs(tmpDir) && !((FileSystem)localFs).getFileStatus(tmpDir).isDir()) {
                throw new IOException("Mkdirs failed to create " + tmpDir.toString());
            }
        }
    }

    public void kill() {
        this.killed = true;
        this.jvmManager.taskKilled(this);
        this.signalDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalDone() {
        Object object = this.lock;
        synchronized (object) {
            this.done = true;
            this.lock.notify();
        }
    }

    public void setExitCode(int exitCode) {
        this.exitCodeSet = true;
        this.exitCode = exitCode;
    }
}

