/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred;

import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.ChecksumException;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.FSDataInputStream;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.FSDataOutputStream;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.FileSystem;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.Path;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.IOUtils;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.IndexRecord;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.JobConf;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Checksum;

class SpillRecord {
    private final ByteBuffer buf;
    private final LongBuffer entries;

    public SpillRecord(int numPartitions) {
        this.buf = ByteBuffer.allocate(numPartitions * 24);
        this.entries = this.buf.asLongBuffer();
    }

    public SpillRecord(Path indexFileName, JobConf job) throws IOException {
        this(indexFileName, job, new CRC32());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpillRecord(Path indexFileName, JobConf job, Checksum crc) throws IOException {
        FileSystem rfs = FileSystem.getLocal(job).getRaw();
        FSDataInputStream in = rfs.open(indexFileName);
        try {
            long length = rfs.getFileStatus(indexFileName).getLen();
            int partitions = (int)length / 24;
            int size = partitions * 24;
            this.buf = ByteBuffer.allocate(size);
            if (crc != null) {
                crc.reset();
                CheckedInputStream chk = new CheckedInputStream(in, crc);
                IOUtils.readFully(chk, this.buf.array(), 0, size);
                if (chk.getChecksum().getValue() != in.readLong()) {
                    throw new ChecksumException("Checksum error reading spill index: " + indexFileName, -1L);
                }
            } else {
                IOUtils.readFully(in, this.buf.array(), 0, size);
            }
            this.entries = this.buf.asLongBuffer();
        }
        finally {
            in.close();
        }
    }

    public int size() {
        return this.entries.capacity() / 3;
    }

    public IndexRecord getIndex(int partition) {
        int pos = partition * 24 / 8;
        return new IndexRecord(this.entries.get(pos), this.entries.get(pos + 1), this.entries.get(pos + 2));
    }

    public void putIndex(IndexRecord rec, int partition) {
        int pos = partition * 24 / 8;
        this.entries.put(pos, rec.startOffset);
        this.entries.put(pos + 1, rec.rawLength);
        this.entries.put(pos + 2, rec.partLength);
    }

    public void writeToFile(Path loc, JobConf job) throws IOException {
        this.writeToFile(loc, job, new CRC32());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(Path loc, JobConf job, Checksum crc) throws IOException {
        FileSystem rfs = FileSystem.getLocal(job).getRaw();
        FilterOutputStream chk = null;
        FSDataOutputStream out = rfs.create(loc);
        try {
            if (crc != null) {
                crc.reset();
                chk = new CheckedOutputStream(out, crc);
                chk.write(this.buf.array());
                out.writeLong(((CheckedOutputStream)chk).getChecksum().getValue());
            } else {
                out.write(this.buf.array());
            }
        }
        finally {
            if (chk != null) {
                chk.close();
            } else {
                out.close();
            }
        }
    }
}

