/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred;

import io.prestosql.hive.jdbc.$internal.org.apache.commons.logging.Log;
import io.prestosql.hive.jdbc.$internal.org.apache.commons.logging.LogFactory;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.JobInProgress;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.TaskInProgress;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.TaskStatus;

class ResourceEstimator {
    private static final Log LOG = LogFactory.getLog("io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.ResourceEstimator");
    private long completedMapsInputSize;
    private long completedMapsOutputSize;
    private int completedMapsUpdates;
    private final JobInProgress job;
    private final int threshholdToUse;

    public ResourceEstimator(JobInProgress job) {
        this.job = job;
        this.threshholdToUse = job.desiredMaps() / 10;
    }

    protected synchronized void updateWithCompletedTask(TaskStatus ts, TaskInProgress tip) {
        if (tip.isMapTask() && ts.getOutputSize() != -1L) {
            ++this.completedMapsUpdates;
            this.completedMapsInputSize += tip.getMapInputSize() + 1L;
            this.completedMapsOutputSize += ts.getOutputSize();
            LOG.info("completedMapsUpdates:" + this.completedMapsUpdates + "  " + "completedMapsInputSize:" + this.completedMapsInputSize + "  " + "completedMapsOutputSize:" + this.completedMapsOutputSize);
        }
    }

    protected synchronized long getEstimatedTotalMapOutputSize() {
        if (this.completedMapsUpdates < this.threshholdToUse) {
            return 0L;
        }
        long inputSize = this.job.getInputLength() + (long)this.job.desiredMaps();
        long estimate = Math.round((double)(inputSize * this.completedMapsOutputSize) * 2.0 / (double)this.completedMapsInputSize);
        LOG.debug("estimate total map output will be " + estimate);
        return estimate;
    }

    long getEstimatedMapOutputSize() {
        long estimate = 0L;
        if (this.job.desiredMaps() > 0) {
            estimate = this.getEstimatedTotalMapOutputSize() / (long)this.job.desiredMaps();
        }
        return estimate;
    }

    long getEstimatedReduceInputSize() {
        if (this.job.desiredReduces() == 0) {
            return 0L;
        }
        return this.getEstimatedTotalMapOutputSize() / (long)this.job.desiredReduces();
    }
}

