/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred;

import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.Writable;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.TaskCompletionEvent;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

class MapTaskCompletionEventsUpdate
implements Writable {
    TaskCompletionEvent[] events;
    boolean reset;

    public MapTaskCompletionEventsUpdate() {
    }

    public MapTaskCompletionEventsUpdate(TaskCompletionEvent[] events, boolean reset) {
        this.events = events;
        this.reset = reset;
    }

    public boolean shouldReset() {
        return this.reset;
    }

    public TaskCompletionEvent[] getMapTaskCompletionEvents() {
        return this.events;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.reset);
        out.writeInt(this.events.length);
        for (TaskCompletionEvent event : this.events) {
            event.write(out);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.reset = in.readBoolean();
        this.events = new TaskCompletionEvent[in.readInt()];
        for (int i = 0; i < this.events.length; ++i) {
            this.events[i] = new TaskCompletionEvent();
            this.events[i].readFields(in);
        }
    }
}

