/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred;

import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.conf.Configuration;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.FileSystem;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.FileUtil;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.Path;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.MapFile;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.SequenceFile;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.Writable;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.WritableComparable;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.compress.CompressionCodec;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.compress.DefaultCodec;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.FileOutputFormat;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.JobConf;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.Partitioner;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.RecordWriter;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.Reporter;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.SequenceFileOutputFormat;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.util.Progressable;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.util.ReflectionUtils;
import java.io.IOException;
import java.util.Arrays;

public class MapFileOutputFormat
extends FileOutputFormat<WritableComparable, Writable> {
    @Override
    public RecordWriter<WritableComparable, Writable> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        Path file = FileOutputFormat.getTaskOutputPath(job, name);
        FileSystem fs = file.getFileSystem(job);
        CompressionCodec codec = null;
        SequenceFile.CompressionType compressionType = SequenceFile.CompressionType.NONE;
        if (MapFileOutputFormat.getCompressOutput(job)) {
            compressionType = SequenceFileOutputFormat.getOutputCompressionType(job);
            Class<CompressionCodec> codecClass = MapFileOutputFormat.getOutputCompressorClass(job, DefaultCodec.class);
            codec = ReflectionUtils.newInstance(codecClass, job);
        }
        final MapFile.Writer out = new MapFile.Writer((Configuration)job, fs, file.toString(), job.getOutputKeyClass().asSubclass(WritableComparable.class), job.getOutputValueClass().asSubclass(Writable.class), compressionType, codec, progress);
        return new RecordWriter<WritableComparable, Writable>(){

            @Override
            public void write(WritableComparable key, Writable value) throws IOException {
                out.append(key, value);
            }

            @Override
            public void close(Reporter reporter) throws IOException {
                out.close();
            }
        };
    }

    public static MapFile.Reader[] getReaders(FileSystem ignored, Path dir, Configuration conf) throws IOException {
        FileSystem fs = dir.getFileSystem(conf);
        Object[] names = FileUtil.stat2Paths(fs.listStatus(dir));
        Arrays.sort(names);
        MapFile.Reader[] parts = new MapFile.Reader[names.length];
        for (int i = 0; i < names.length; ++i) {
            parts[i] = new MapFile.Reader(fs, ((Path)names[i]).toString(), conf);
        }
        return parts;
    }

    public static <K extends WritableComparable, V extends Writable> Writable getEntry(MapFile.Reader[] readers, Partitioner<K, V> partitioner, K key, V value) throws IOException {
        int part = partitioner.getPartition(key, value, readers.length);
        return readers[part].get(key, value);
    }
}

