/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred;

import io.prestosql.hive.jdbc.$internal.org.apache.commons.logging.Log;
import io.prestosql.hive.jdbc.$internal.org.apache.commons.logging.LogFactory;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.FileUtil;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.JVMId;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.JobConf;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.JobID;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.TaskLog;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.TaskRunner;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.TaskTracker;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.util.Shell;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;

class JvmManager {
    public static final Log LOG = LogFactory.getLog("io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.JvmManager");
    JvmManagerForType mapJvmManager;
    JvmManagerForType reduceJvmManager;

    public JvmEnv constructJvmEnv(List<String> setup, Vector<String> vargs, File stdout, File stderr, long logSize, File workDir, Map<String, String> env, String pidFile, JobConf conf) {
        return new JvmEnv(setup, vargs, stdout, stderr, logSize, workDir, env, pidFile, conf);
    }

    public JvmManager(TaskTracker tracker) {
        this.mapJvmManager = new JvmManagerForType(tracker.getMaxCurrentMapTasks(), true);
        this.reduceJvmManager = new JvmManagerForType(tracker.getMaxCurrentReduceTasks(), false);
    }

    public void stop() {
        this.mapJvmManager.stop();
        this.reduceJvmManager.stop();
    }

    public boolean isJvmKnown(JVMId jvmId) {
        if (jvmId.isMapJVM()) {
            return this.mapJvmManager.isJvmknown(jvmId);
        }
        return this.reduceJvmManager.isJvmknown(jvmId);
    }

    public void launchJvm(TaskRunner t, JvmEnv env) {
        if (t.getTask().isMapTask()) {
            this.mapJvmManager.reapJvm(t, env);
        } else {
            this.reduceJvmManager.reapJvm(t, env);
        }
    }

    public TaskTracker.TaskInProgress getTaskForJvm(JVMId jvmId) {
        if (jvmId.isMapJVM()) {
            return this.mapJvmManager.getTaskForJvm(jvmId);
        }
        return this.reduceJvmManager.getTaskForJvm(jvmId);
    }

    public void taskFinished(TaskRunner tr) {
        if (tr.getTask().isMapTask()) {
            this.mapJvmManager.taskFinished(tr);
        } else {
            this.reduceJvmManager.taskFinished(tr);
        }
    }

    public void taskKilled(TaskRunner tr) {
        if (tr.getTask().isMapTask()) {
            this.mapJvmManager.taskKilled(tr);
        } else {
            this.reduceJvmManager.taskKilled(tr);
        }
    }

    public void killJvm(JVMId jvmId) {
        if (jvmId.isMap) {
            this.mapJvmManager.killJvm(jvmId);
        } else {
            this.reduceJvmManager.killJvm(jvmId);
        }
    }

    static class JvmEnv {
        List<String> vargs;
        List<String> setup;
        File stdout;
        File stderr;
        File workDir;
        String pidFile;
        long logSize;
        JobConf conf;
        Map<String, String> env;

        public JvmEnv(List<String> setup, Vector<String> vargs, File stdout, File stderr, long logSize, File workDir, Map<String, String> env, String pidFile, JobConf conf) {
            this.setup = setup;
            this.vargs = vargs;
            this.stdout = stdout;
            this.stderr = stderr;
            this.workDir = workDir;
            this.env = env;
            this.pidFile = pidFile;
            this.conf = conf;
        }
    }

    private static class JvmManagerForType {
        Map<JVMId, TaskRunner> jvmToRunningTask = new HashMap<JVMId, TaskRunner>();
        Map<TaskRunner, JVMId> runningTaskToJvm = new HashMap<TaskRunner, JVMId>();
        Map<JVMId, JvmRunner> jvmIdToRunner = new HashMap<JVMId, JvmRunner>();
        int maxJvms;
        boolean isMap;
        Random rand = new Random(System.currentTimeMillis());

        public JvmManagerForType(int maxJvms, boolean isMap) {
            this.maxJvms = maxJvms;
            this.isMap = isMap;
        }

        public synchronized void setRunningTaskForJvm(JVMId jvmId, TaskRunner t) {
            this.jvmToRunningTask.put(jvmId, t);
            this.runningTaskToJvm.put(t, jvmId);
            this.jvmIdToRunner.get(jvmId).setBusy(true);
        }

        public synchronized TaskTracker.TaskInProgress getTaskForJvm(JVMId jvmId) {
            if (this.jvmToRunningTask.containsKey(jvmId)) {
                return this.jvmToRunningTask.get(jvmId).getTaskInProgress();
            }
            return null;
        }

        public synchronized boolean isJvmknown(JVMId jvmId) {
            return this.jvmIdToRunner.containsKey(jvmId);
        }

        public synchronized void taskFinished(TaskRunner tr) {
            JVMId jvmId = this.runningTaskToJvm.remove(tr);
            if (jvmId != null) {
                this.jvmToRunningTask.remove(jvmId);
                JvmRunner jvmRunner = this.jvmIdToRunner.get(jvmId);
                if (jvmRunner != null) {
                    jvmRunner.taskRan();
                }
            }
        }

        public synchronized void taskKilled(TaskRunner tr) {
            JVMId jvmId = this.runningTaskToJvm.remove(tr);
            if (jvmId != null) {
                this.jvmToRunningTask.remove(jvmId);
                this.killJvm(jvmId);
            }
        }

        public synchronized void killJvm(JVMId jvmId) {
            JvmRunner jvmRunner = this.jvmIdToRunner.get(jvmId);
            if (jvmRunner != null) {
                jvmRunner.kill();
            }
        }

        public synchronized void stop() {
            ArrayList<JvmRunner> list = new ArrayList<JvmRunner>();
            list.addAll(this.jvmIdToRunner.values());
            for (JvmRunner jvm : list) {
                jvm.kill();
            }
        }

        private synchronized void removeJvm(JVMId jvmId) {
            this.jvmIdToRunner.remove(jvmId);
        }

        private synchronized void reapJvm(TaskRunner t, JvmEnv env) {
            if (t.getTaskInProgress().wasKilled()) {
                return;
            }
            boolean spawnNewJvm = false;
            JobID jobId = t.getTask().getJobID();
            int numJvmsSpawned = this.jvmIdToRunner.size();
            JvmRunner runnerToKill = null;
            if (numJvmsSpawned >= this.maxJvms) {
                Iterator<Map.Entry<JVMId, JvmRunner>> jvmIter = this.jvmIdToRunner.entrySet().iterator();
                while (jvmIter.hasNext()) {
                    JvmRunner jvmRunner = jvmIter.next().getValue();
                    JobID jId = jvmRunner.jvmId.getJobId();
                    if (jId.equals(jobId) && !jvmRunner.isBusy() && !jvmRunner.ranAll()) {
                        this.setRunningTaskForJvm(jvmRunner.jvmId, t);
                        LOG.info("No new JVM spawned for jobId/taskid: " + jobId + "/" + t.getTask().getTaskID() + ". Attempting to reuse: " + jvmRunner.jvmId);
                        return;
                    }
                    if ((!jId.equals(jobId) || !jvmRunner.ranAll()) && (jId.equals(jobId) || jvmRunner.isBusy())) continue;
                    runnerToKill = jvmRunner;
                    spawnNewJvm = true;
                }
            } else {
                spawnNewJvm = true;
            }
            if (spawnNewJvm) {
                if (runnerToKill != null) {
                    LOG.info("Killing JVM: " + runnerToKill.jvmId);
                    runnerToKill.kill();
                }
                this.spawnNewJvm(jobId, env, t);
                return;
            }
            throw new RuntimeException("Inconsistent state!!! JVM Manager reached an unstable state while reaping a JVM for task: " + t.getTask().getTaskID() + " " + this.getDetails());
        }

        private String getDetails() {
            StringBuffer details = new StringBuffer();
            details.append("Number of active JVMs:").append(this.jvmIdToRunner.size());
            for (JVMId jvmId : this.jvmIdToRunner.keySet()) {
                details.append("\n  JVMId ").append(jvmId.toString()).append(" #Tasks ran: ").append(this.jvmIdToRunner.get((Object)jvmId).numTasksRan).append(" Currently busy? ").append(this.jvmIdToRunner.get((Object)jvmId).busy).append(" Currently running: ").append(this.jvmToRunningTask.get(jvmId).getTask().getTaskID().toString());
            }
            return details.toString();
        }

        private void spawnNewJvm(JobID jobId, JvmEnv env, TaskRunner t) {
            JvmRunner jvmRunner = new JvmRunner(env, jobId);
            this.jvmIdToRunner.put(jvmRunner.jvmId, jvmRunner);
            jvmRunner.setDaemon(true);
            jvmRunner.setName("JVM Runner " + jvmRunner.jvmId + " spawned.");
            this.setRunningTaskForJvm(jvmRunner.jvmId, t);
            LOG.info(jvmRunner.getName());
            jvmRunner.start();
        }

        private synchronized void updateOnJvmExit(JVMId jvmId, int exitCode, boolean killed) {
            this.removeJvm(jvmId);
            TaskRunner t = this.jvmToRunningTask.remove(jvmId);
            if (t != null) {
                this.runningTaskToJvm.remove(t);
                if (!killed && exitCode != 0) {
                    t.setExitCode(exitCode);
                }
                t.signalDone();
            }
        }

        private class JvmRunner
        extends Thread {
            JvmEnv env;
            volatile boolean killed = false;
            volatile int numTasksRan;
            final int numTasksToRun;
            JVMId jvmId;
            volatile boolean busy = true;
            private Shell.ShellCommandExecutor shexec;

            public JvmRunner(JvmEnv env, JobID jobId) {
                this.env = env;
                this.jvmId = new JVMId(jobId, JvmManagerForType.this.isMap, JvmManagerForType.this.rand.nextInt());
                this.numTasksToRun = env.conf.getNumTasksToExecutePerJvm();
                LOG.info("In JvmRunner constructed JVM ID: " + this.jvmId);
            }

            @Override
            public void run() {
                this.runChild(this.env);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runChild(JvmEnv env) {
                try {
                    env.vargs.add(Integer.toString(this.jvmId.getId()));
                    List<String> wrappedCommand = TaskLog.captureOutAndError(env.setup, env.vargs, env.stdout, env.stderr, env.logSize, env.pidFile);
                    this.shexec = new Shell.ShellCommandExecutor(wrappedCommand.toArray(new String[0]), env.workDir, env.env);
                    this.shexec.execute();
                }
                catch (IOException ioe) {
                }
                finally {
                    if (this.shexec == null) {
                        return;
                    }
                    int exitCode = this.shexec.getExitCode();
                    JvmManagerForType.this.updateOnJvmExit(this.jvmId, exitCode, this.killed);
                    LOG.info("JVM : " + this.jvmId + " exited. Number of tasks it ran: " + this.numTasksRan);
                    try {
                        if (env.conf.getNumTasksToExecutePerJvm() != 1) {
                            FileUtil.fullyDelete(env.workDir);
                        }
                    }
                    catch (IOException ie) {}
                }
            }

            public void kill() {
                Process process;
                if (this.shexec != null && (process = this.shexec.getProcess()) != null) {
                    process.destroy();
                }
                JvmManagerForType.this.removeJvm(this.jvmId);
            }

            public void taskRan() {
                this.busy = false;
                ++this.numTasksRan;
            }

            public boolean ranAll() {
                return this.numTasksRan == this.numTasksToRun;
            }

            public void setBusy(boolean busy) {
                this.busy = busy;
            }

            public boolean isBusy() {
                return this.busy;
            }
        }
    }
}

