/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred;

import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.JobConf;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.JobID;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.JobInProgress;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.JobTracker;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.JobTrackerInstrumentation;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.TaskAttemptID;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.metrics.MetricsContext;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.metrics.MetricsRecord;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.metrics.MetricsUtil;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.metrics.Updater;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.metrics.jvm.JvmMetrics;

class JobTrackerMetricsInst
extends JobTrackerInstrumentation
implements Updater {
    private final MetricsRecord metricsRecord;
    private int numMapTasksLaunched = 0;
    private int numMapTasksCompleted = 0;
    private int numMapTasksFailed = 0;
    private int numReduceTasksLaunched = 0;
    private int numReduceTasksCompleted = 0;
    private int numReduceTasksFailed = 0;
    private int numJobsSubmitted = 0;
    private int numJobsCompleted = 0;
    private int numWaitingTasks = 0;

    public JobTrackerMetricsInst(JobTracker tracker, JobConf conf) {
        super(tracker, conf);
        String sessionId = conf.getSessionId();
        JvmMetrics.init("JobTracker", sessionId);
        MetricsContext context = MetricsUtil.getContext("mapred");
        this.metricsRecord = MetricsUtil.createRecord(context, "jobtracker");
        this.metricsRecord.setTag("sessionId", sessionId);
        context.registerUpdater(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpdates(MetricsContext unused) {
        JobTrackerMetricsInst jobTrackerMetricsInst = this;
        synchronized (jobTrackerMetricsInst) {
            this.metricsRecord.incrMetric("maps_launched", this.numMapTasksLaunched);
            this.metricsRecord.incrMetric("maps_completed", this.numMapTasksCompleted);
            this.metricsRecord.incrMetric("maps_failed", this.numMapTasksFailed);
            this.metricsRecord.incrMetric("reduces_launched", this.numReduceTasksLaunched);
            this.metricsRecord.incrMetric("reduces_completed", this.numReduceTasksCompleted);
            this.metricsRecord.incrMetric("reduces_failed", this.numReduceTasksFailed);
            this.metricsRecord.incrMetric("jobs_submitted", this.numJobsSubmitted);
            this.metricsRecord.incrMetric("jobs_completed", this.numJobsCompleted);
            this.metricsRecord.incrMetric("waiting_tasks", this.numWaitingTasks);
            this.numMapTasksLaunched = 0;
            this.numMapTasksCompleted = 0;
            this.numMapTasksFailed = 0;
            this.numReduceTasksLaunched = 0;
            this.numReduceTasksCompleted = 0;
            this.numReduceTasksFailed = 0;
            this.numWaitingTasks = 0;
            this.numJobsSubmitted = 0;
            this.numJobsCompleted = 0;
        }
        this.metricsRecord.update();
        if (this.tracker != null) {
            for (JobInProgress jip : this.tracker.getRunningJobs()) {
                jip.updateMetrics();
            }
        }
    }

    @Override
    public synchronized void launchMap(TaskAttemptID taskAttemptID) {
        ++this.numMapTasksLaunched;
        this.decWaiting(taskAttemptID.getJobID(), 1);
    }

    @Override
    public synchronized void completeMap(TaskAttemptID taskAttemptID) {
        ++this.numMapTasksCompleted;
    }

    @Override
    public synchronized void failedMap(TaskAttemptID taskAttemptID) {
        ++this.numMapTasksFailed;
        this.addWaiting(taskAttemptID.getJobID(), 1);
    }

    @Override
    public synchronized void launchReduce(TaskAttemptID taskAttemptID) {
        ++this.numReduceTasksLaunched;
        this.decWaiting(taskAttemptID.getJobID(), 1);
    }

    @Override
    public synchronized void completeReduce(TaskAttemptID taskAttemptID) {
        ++this.numReduceTasksCompleted;
    }

    @Override
    public synchronized void failedReduce(TaskAttemptID taskAttemptID) {
        ++this.numReduceTasksFailed;
        this.addWaiting(taskAttemptID.getJobID(), 1);
    }

    @Override
    public synchronized void submitJob(JobConf conf, JobID id) {
        ++this.numJobsSubmitted;
    }

    @Override
    public synchronized void completeJob(JobConf conf, JobID id) {
        ++this.numJobsCompleted;
    }

    @Override
    public synchronized void addWaiting(JobID id, int tasks) {
        this.numWaitingTasks += tasks;
    }

    @Override
    public synchronized void decWaiting(JobID id, int tasks) {
        this.numWaitingTasks -= tasks;
    }
}

