/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred;

import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.conf.Configured;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.JobClient;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.JobConf;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.JobQueueInfo;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.JobStatus;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.util.Tool;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.util.ToolRunner;
import java.io.IOException;

class JobQueueClient
extends Configured
implements Tool {
    JobClient jc;

    public JobQueueClient() {
    }

    public JobQueueClient(JobConf conf) throws IOException {
        this.setConf(conf);
    }

    private void init(JobConf conf) throws IOException {
        this.setConf(conf);
        this.jc = new JobClient(conf);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int run(String[] argv) throws Exception {
        int exitcode = -1;
        if (argv.length < 1) {
            this.displayUsage("");
            return exitcode;
        }
        String cmd = argv[0];
        boolean displayQueueList = false;
        boolean displayQueueInfoWithJobs = false;
        boolean displayQueueInfoWithoutJobs = false;
        if ("-list".equals(cmd)) {
            displayQueueList = true;
        } else {
            if (!"-info".equals(cmd)) {
                this.displayUsage(cmd);
                return exitcode;
            }
            if (argv.length == 2 && !argv[1].equals("-showJobs")) {
                displayQueueInfoWithoutJobs = true;
            } else {
                if (argv.length != 3) {
                    this.displayUsage(cmd);
                    return exitcode;
                }
                if (!argv[2].equals("-showJobs")) {
                    this.displayUsage(cmd);
                    return exitcode;
                }
                displayQueueInfoWithJobs = true;
            }
        }
        JobConf conf = new JobConf(this.getConf());
        this.init(conf);
        if (displayQueueList) {
            this.displayQueueList();
            return 0;
        }
        if (displayQueueInfoWithoutJobs) {
            this.displayQueueInfo(argv[1], false);
            return 0;
        }
        if (!displayQueueInfoWithJobs) return exitcode;
        this.displayQueueInfo(argv[1], true);
        return 0;
    }

    private void displayQueueInfo(String queue, boolean showJobs) throws IOException {
        JobQueueInfo schedInfo = this.jc.getQueueInfo(queue);
        if (schedInfo == null) {
            System.out.printf("Queue Name : %s has no scheduling information \n", queue);
        } else {
            System.out.printf("Queue Name : %s \n", schedInfo.getQueueName());
            System.out.printf("Scheduling Info : %s \n", schedInfo.getSchedulingInfo());
        }
        if (showJobs) {
            System.out.printf("Job List\n", new Object[0]);
            JobStatus[] jobs = this.jc.getJobsFromQueue(queue);
            if (jobs == null) {
                jobs = new JobStatus[]{};
            }
            this.jc.displayJobList(jobs);
        }
    }

    private void displayQueueList() throws IOException {
        JobQueueInfo[] queues;
        for (JobQueueInfo queue : queues = this.jc.getQueues()) {
            String schedInfo = queue.getSchedulingInfo();
            if (schedInfo.trim().equals("")) {
                schedInfo = "N/A";
            }
            System.out.printf("Queue Name : %s \n", queue.getQueueName());
            System.out.printf("Scheduling Info : %s \n", queue.getSchedulingInfo());
        }
    }

    private void displayUsage(String cmd) {
        String prefix = "Usage: JobQueueClient ";
        if ("-queueinfo".equals(cmd)) {
            System.err.println(prefix + "[" + cmd + "<job-queue-name> [-showJobs]]");
        } else {
            System.err.printf(prefix + "<command> <args>\n", new Object[0]);
            System.err.printf("\t[-list]\n", new Object[0]);
            System.err.printf("\t[-info <job-queue-name> [-showJobs]]\n\n", new Object[0]);
            ToolRunner.printGenericCommandUsage(System.out);
        }
    }

    public static void main(String[] argv) throws Exception {
        int res = ToolRunner.run(new JobQueueClient(), argv);
        System.exit(res);
    }
}

