/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred;

import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.Text;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.Writable;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.WritableFactories;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.WritableFactory;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.JobID;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URL;

public class JobProfile
implements Writable {
    String user;
    final JobID jobid;
    String jobFile;
    String url;
    String name;
    String queueName;

    public JobProfile() {
        this.jobid = new JobID();
    }

    public JobProfile(String user, io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapreduce.JobID jobid, String jobFile, String url, String name) {
        this(user, jobid, jobFile, url, name, "default");
    }

    public JobProfile(String user, io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapreduce.JobID jobid, String jobFile, String url, String name, String queueName) {
        this.user = user;
        this.jobid = JobID.downgrade(jobid);
        this.jobFile = jobFile;
        this.url = url;
        this.name = name;
        this.queueName = queueName;
    }

    @Deprecated
    public JobProfile(String user, String jobid, String jobFile, String url, String name) {
        this(user, JobID.forName(jobid), jobFile, url, name);
    }

    public String getUser() {
        return this.user;
    }

    public JobID getJobID() {
        return this.jobid;
    }

    @Deprecated
    public String getJobId() {
        return this.jobid.toString();
    }

    public String getJobFile() {
        return this.jobFile;
    }

    public URL getURL() {
        try {
            return new URL(this.url);
        }
        catch (IOException ie) {
            return null;
        }
    }

    public String getJobName() {
        return this.name;
    }

    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.jobid.write(out);
        Text.writeString(out, this.jobFile);
        Text.writeString(out, this.url);
        Text.writeString(out, this.user);
        Text.writeString(out, this.name);
        Text.writeString(out, this.queueName);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.jobid.readFields(in);
        this.jobFile = Text.readString(in);
        this.url = Text.readString(in);
        this.user = Text.readString(in);
        this.name = Text.readString(in);
        this.queueName = Text.readString(in);
    }

    static {
        WritableFactories.setFactory(JobProfile.class, new WritableFactory(){

            @Override
            public Writable newInstance() {
                return new JobProfile();
            }
        });
    }
}

