/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred;

import io.prestosql.hive.jdbc.$internal.org.apache.commons.logging.Log;
import io.prestosql.hive.jdbc.$internal.org.apache.commons.logging.LogFactory;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.FSDataInputStream;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.FSDataOutputStream;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.FileStatus;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.FileSystem;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.Path;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.PathFilter;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.permission.FsPermission;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.Counters;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.FileOutputFormat;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.JobConf;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.JobID;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.JobInProgress;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.JobPriority;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.TaskAttemptID;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.TaskID;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.TaskLogServlet;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JobHistory {
    static final long VERSION = 1L;
    public static final Log LOG = LogFactory.getLog(JobHistory.class);
    private static final String DELIMITER = " ";
    static final char LINE_DELIMITER_CHAR = '.';
    static final char[] charsToEscape = new char[]{'\"', '=', '.'};
    static final String DIGITS = "[0-9]+";
    static final String KEY = "(\\w+)";
    static final String VALUE = "[^\"\\\\]*(?:\\\\.[^\"\\\\]*)*";
    static final Pattern pattern = Pattern.compile("(\\w+)=\"[^\"\\\\]*(?:\\\\.[^\"\\\\]*)*\"");
    public static final int JOB_NAME_TRIM_LENGTH = 50;
    private static String JOBTRACKER_UNIQUE_STRING = null;
    private static String LOG_DIR = null;
    private static Map<String, ArrayList<PrintWriter>> openJobs = new ConcurrentHashMap<String, ArrayList<PrintWriter>>();
    private static boolean disableHistory = false;
    private static final String SECONDARY_FILE_SUFFIX = ".recover";
    private static long jobHistoryBlockSize = 0L;
    private static String jobtrackerHostname;
    static final FsPermission HISTORY_DIR_PERMISSION;
    static final FsPermission HISTORY_FILE_PERMISSION;
    private static JobConf jtConf;
    private static Map<Keys, String> parseBuffer;

    public static boolean init(JobConf conf, String hostname, long jobTrackerStartTime) {
        try {
            LOG_DIR = conf.get("hadoop.job.history.location", "file:///" + new File(System.getProperty("hadoop.log.dir")).getAbsolutePath() + File.separator + "history");
            JOBTRACKER_UNIQUE_STRING = hostname + "_" + String.valueOf(jobTrackerStartTime) + "_";
            jobtrackerHostname = hostname;
            Path logDir = new Path(LOG_DIR);
            FileSystem fs = logDir.getFileSystem(conf);
            if (!fs.exists(logDir) && !fs.mkdirs(logDir, new FsPermission(HISTORY_DIR_PERMISSION))) {
                throw new IOException("Mkdirs failed to create " + logDir.toString());
            }
            conf.set("hadoop.job.history.location", LOG_DIR);
            disableHistory = false;
            jobHistoryBlockSize = conf.getLong("mapred.jobtracker.job.history.block.size", 0x300000L);
            jtConf = conf;
        }
        catch (IOException e) {
            LOG.error("Failed to initialize JobHistory log file", e);
            disableHistory = true;
        }
        return !disableHistory;
    }

    static String escapeString(String data) {
        return StringUtils.escapeString(data, '\\', charsToEscape);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseHistoryFromFS(String path, Listener l, FileSystem fs) throws IOException {
        FSDataInputStream in = fs.open(new Path(path));
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        try {
            String line = null;
            StringBuffer buf = new StringBuffer();
            line = reader.readLine();
            if (line == null) {
                return;
            }
            MetaInfoManager mgr = new MetaInfoManager(line);
            boolean isEscaped = mgr.isValueEscaped();
            String lineDelim = String.valueOf(mgr.getLineDelim());
            String escapedLineDelim = StringUtils.escapeString(lineDelim, '\\', mgr.getLineDelim());
            do {
                buf.append(line);
                if (!line.trim().endsWith(lineDelim) || line.trim().endsWith(escapedLineDelim)) {
                    buf.append("\n");
                    continue;
                }
                JobHistory.parseLine(buf.toString(), l, isEscaped);
                buf = new StringBuffer();
            } while ((line = reader.readLine()) != null);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ex) {}
        }
    }

    private static void parseLine(String line, Listener l, boolean isEscaped) throws IOException {
        int idx = line.indexOf(32);
        String recType = line.substring(0, idx);
        String data = line.substring(idx + 1, line.length());
        Matcher matcher = pattern.matcher(data);
        while (matcher.find()) {
            String tuple = matcher.group(0);
            String[] parts = StringUtils.split(tuple, '\\', '=');
            String value = parts[1].substring(1, parts[1].length() - 1);
            if (isEscaped) {
                value = StringUtils.unEscapeString(value, '\\', charsToEscape);
            }
            parseBuffer.put(Keys.valueOf(parts[0]), value);
        }
        l.handle(RecordTypes.valueOf(recType), parseBuffer);
        parseBuffer.clear();
    }

    static void log(PrintWriter out, RecordTypes recordType, Keys key, String value) {
        value = JobHistory.escapeString(value);
        out.println(recordType.name() + DELIMITER + (Object)((Object)key) + "=\"" + value + "\"" + DELIMITER + '.');
    }

    static void log(ArrayList<PrintWriter> writers, RecordTypes recordType, Keys[] keys, String[] values) {
        StringBuffer buf = new StringBuffer(recordType.name());
        buf.append(DELIMITER);
        for (int i = 0; i < keys.length; ++i) {
            buf.append((Object)keys[i]);
            buf.append("=\"");
            values[i] = JobHistory.escapeString(values[i]);
            buf.append(values[i]);
            buf.append("\"");
            buf.append(DELIMITER);
        }
        buf.append('.');
        for (PrintWriter out : writers) {
            out.println(buf.toString());
        }
    }

    public static boolean isDisableHistory() {
        return disableHistory;
    }

    public static void setDisableHistory(boolean disableHistory) {
        JobHistory.disableHistory = disableHistory;
    }

    static Path getJobHistoryLocation() {
        return new Path(LOG_DIR);
    }

    public static String getTaskLogsUrl(TaskAttempt attempt) {
        if (attempt.get(Keys.HTTP_PORT).equals("") || attempt.get(Keys.TRACKER_NAME).equals("") || attempt.get(Keys.TASK_ATTEMPT_ID).equals("")) {
            return null;
        }
        String taskTrackerName = JobInProgress.convertTrackerNameToHostName(attempt.get(Keys.TRACKER_NAME));
        return TaskLogServlet.getTaskLogUrl(taskTrackerName, attempt.get(Keys.HTTP_PORT), attempt.get(Keys.TASK_ATTEMPT_ID));
    }

    static {
        HISTORY_DIR_PERMISSION = FsPermission.createImmutable((short)488);
        HISTORY_FILE_PERMISSION = FsPermission.createImmutable((short)480);
        parseBuffer = new HashMap<Keys, String>();
    }

    public static class HistoryCleaner
    implements Runnable {
        static final long ONE_DAY_IN_MS = 86400000L;
        static final long THIRTY_DAYS_IN_MS = 2592000000L;
        private long now;
        private static boolean isRunning = false;
        private static long lastRan = 0L;

        @Override
        public void run() {
            if (isRunning) {
                return;
            }
            this.now = System.currentTimeMillis();
            if (lastRan != 0L && this.now - lastRan < 86400000L) {
                return;
            }
            lastRan = this.now;
            isRunning = true;
            try {
                Path logDir = new Path(LOG_DIR);
                FileSystem fs = logDir.getFileSystem(jtConf);
                FileStatus[] historyFiles = fs.listStatus(logDir);
                if (historyFiles != null) {
                    for (FileStatus f : historyFiles) {
                        if (this.now - f.getModificationTime() <= 2592000000L) continue;
                        fs.delete(f.getPath(), true);
                        LOG.info("Deleting old history file : " + f.getPath());
                    }
                }
            }
            catch (IOException ie) {
                LOG.info("Error cleaning up history directory" + StringUtils.stringifyException(ie));
            }
            isRunning = false;
        }

        static long getLastRan() {
            return lastRan;
        }
    }

    public static interface Listener {
        public void handle(RecordTypes var1, Map<Keys, String> var2) throws IOException;
    }

    public static class ReduceAttempt
    extends TaskAttempt {
        @Deprecated
        public static void logStarted(TaskAttemptID taskAttemptId, long startTime, String hostName) {
            ReduceAttempt.logStarted(taskAttemptId, startTime, hostName, -1, Values.REDUCE.name());
        }

        public static void logStarted(TaskAttemptID taskAttemptId, long startTime, String trackerName, int httpPort, String taskType) {
            ArrayList writer;
            if (!disableHistory && null != (writer = (ArrayList)openJobs.get(JOBTRACKER_UNIQUE_STRING + taskAttemptId.getJobID()))) {
                JobHistory.log(writer, RecordTypes.ReduceAttempt, new Keys[]{Keys.TASK_TYPE, Keys.TASKID, Keys.TASK_ATTEMPT_ID, Keys.START_TIME, Keys.TRACKER_NAME, Keys.HTTP_PORT}, new String[]{taskType, taskAttemptId.getTaskID().toString(), taskAttemptId.toString(), String.valueOf(startTime), trackerName, httpPort == -1 ? "" : String.valueOf(httpPort)});
            }
        }

        @Deprecated
        public static void logFinished(TaskAttemptID taskAttemptId, long shuffleFinished, long sortFinished, long finishTime, String hostName) {
            ReduceAttempt.logFinished(taskAttemptId, shuffleFinished, sortFinished, finishTime, hostName, Values.REDUCE.name(), "", new Counters());
        }

        public static void logFinished(TaskAttemptID taskAttemptId, long shuffleFinished, long sortFinished, long finishTime, String hostName, String taskType, String stateString, Counters counter) {
            ArrayList writer;
            if (!disableHistory && null != (writer = (ArrayList)openJobs.get(JOBTRACKER_UNIQUE_STRING + taskAttemptId.getJobID()))) {
                JobHistory.log(writer, RecordTypes.ReduceAttempt, new Keys[]{Keys.TASK_TYPE, Keys.TASKID, Keys.TASK_ATTEMPT_ID, Keys.TASK_STATUS, Keys.SHUFFLE_FINISHED, Keys.SORT_FINISHED, Keys.FINISH_TIME, Keys.HOSTNAME, Keys.STATE_STRING, Keys.COUNTERS}, new String[]{taskType, taskAttemptId.getTaskID().toString(), taskAttemptId.toString(), Values.SUCCESS.name(), String.valueOf(shuffleFinished), String.valueOf(sortFinished), String.valueOf(finishTime), hostName, stateString, counter.makeEscapedCompactString()});
            }
        }

        @Deprecated
        public static void logFailed(TaskAttemptID taskAttemptId, long timestamp, String hostName, String error) {
            ReduceAttempt.logFailed(taskAttemptId, timestamp, hostName, error, Values.REDUCE.name());
        }

        public static void logFailed(TaskAttemptID taskAttemptId, long timestamp, String hostName, String error, String taskType) {
            ArrayList writer;
            if (!disableHistory && null != (writer = (ArrayList)openJobs.get(JOBTRACKER_UNIQUE_STRING + taskAttemptId.getJobID()))) {
                JobHistory.log(writer, RecordTypes.ReduceAttempt, new Keys[]{Keys.TASK_TYPE, Keys.TASKID, Keys.TASK_ATTEMPT_ID, Keys.TASK_STATUS, Keys.FINISH_TIME, Keys.HOSTNAME, Keys.ERROR}, new String[]{taskType, taskAttemptId.getTaskID().toString(), taskAttemptId.toString(), Values.FAILED.name(), String.valueOf(timestamp), hostName, error});
            }
        }

        @Deprecated
        public static void logKilled(TaskAttemptID taskAttemptId, long timestamp, String hostName, String error) {
            ReduceAttempt.logKilled(taskAttemptId, timestamp, hostName, error, Values.REDUCE.name());
        }

        public static void logKilled(TaskAttemptID taskAttemptId, long timestamp, String hostName, String error, String taskType) {
            ArrayList writer;
            if (!disableHistory && null != (writer = (ArrayList)openJobs.get(JOBTRACKER_UNIQUE_STRING + taskAttemptId.getJobID()))) {
                JobHistory.log(writer, RecordTypes.ReduceAttempt, new Keys[]{Keys.TASK_TYPE, Keys.TASKID, Keys.TASK_ATTEMPT_ID, Keys.TASK_STATUS, Keys.FINISH_TIME, Keys.HOSTNAME, Keys.ERROR}, new String[]{taskType, taskAttemptId.getTaskID().toString(), taskAttemptId.toString(), Values.KILLED.name(), String.valueOf(timestamp), hostName, error});
            }
        }
    }

    public static class MapAttempt
    extends TaskAttempt {
        @Deprecated
        public static void logStarted(TaskAttemptID taskAttemptId, long startTime, String hostName) {
            MapAttempt.logStarted(taskAttemptId, startTime, hostName, -1, Values.MAP.name());
        }

        public static void logStarted(TaskAttemptID taskAttemptId, long startTime, String trackerName, int httpPort, String taskType) {
            ArrayList writer;
            if (!disableHistory && null != (writer = (ArrayList)openJobs.get(JOBTRACKER_UNIQUE_STRING + taskAttemptId.getJobID()))) {
                JobHistory.log(writer, RecordTypes.MapAttempt, new Keys[]{Keys.TASK_TYPE, Keys.TASKID, Keys.TASK_ATTEMPT_ID, Keys.START_TIME, Keys.TRACKER_NAME, Keys.HTTP_PORT}, new String[]{taskType, taskAttemptId.getTaskID().toString(), taskAttemptId.toString(), String.valueOf(startTime), trackerName, httpPort == -1 ? "" : String.valueOf(httpPort)});
            }
        }

        @Deprecated
        public static void logFinished(TaskAttemptID taskAttemptId, long finishTime, String hostName) {
            MapAttempt.logFinished(taskAttemptId, finishTime, hostName, Values.MAP.name(), "", new Counters());
        }

        public static void logFinished(TaskAttemptID taskAttemptId, long finishTime, String hostName, String taskType, String stateString, Counters counter) {
            ArrayList writer;
            if (!disableHistory && null != (writer = (ArrayList)openJobs.get(JOBTRACKER_UNIQUE_STRING + taskAttemptId.getJobID()))) {
                JobHistory.log(writer, RecordTypes.MapAttempt, new Keys[]{Keys.TASK_TYPE, Keys.TASKID, Keys.TASK_ATTEMPT_ID, Keys.TASK_STATUS, Keys.FINISH_TIME, Keys.HOSTNAME, Keys.STATE_STRING, Keys.COUNTERS}, new String[]{taskType, taskAttemptId.getTaskID().toString(), taskAttemptId.toString(), Values.SUCCESS.name(), String.valueOf(finishTime), hostName, stateString, counter.makeEscapedCompactString()});
            }
        }

        @Deprecated
        public static void logFailed(TaskAttemptID taskAttemptId, long timestamp, String hostName, String error) {
            MapAttempt.logFailed(taskAttemptId, timestamp, hostName, error, Values.MAP.name());
        }

        public static void logFailed(TaskAttemptID taskAttemptId, long timestamp, String hostName, String error, String taskType) {
            ArrayList writer;
            if (!disableHistory && null != (writer = (ArrayList)openJobs.get(JOBTRACKER_UNIQUE_STRING + taskAttemptId.getJobID()))) {
                JobHistory.log(writer, RecordTypes.MapAttempt, new Keys[]{Keys.TASK_TYPE, Keys.TASKID, Keys.TASK_ATTEMPT_ID, Keys.TASK_STATUS, Keys.FINISH_TIME, Keys.HOSTNAME, Keys.ERROR}, new String[]{taskType, taskAttemptId.getTaskID().toString(), taskAttemptId.toString(), Values.FAILED.name(), String.valueOf(timestamp), hostName, error});
            }
        }

        @Deprecated
        public static void logKilled(TaskAttemptID taskAttemptId, long timestamp, String hostName, String error) {
            MapAttempt.logKilled(taskAttemptId, timestamp, hostName, error, Values.MAP.name());
        }

        public static void logKilled(TaskAttemptID taskAttemptId, long timestamp, String hostName, String error, String taskType) {
            ArrayList writer;
            if (!disableHistory && null != (writer = (ArrayList)openJobs.get(JOBTRACKER_UNIQUE_STRING + taskAttemptId.getJobID()))) {
                JobHistory.log(writer, RecordTypes.MapAttempt, new Keys[]{Keys.TASK_TYPE, Keys.TASKID, Keys.TASK_ATTEMPT_ID, Keys.TASK_STATUS, Keys.FINISH_TIME, Keys.HOSTNAME, Keys.ERROR}, new String[]{taskType, taskAttemptId.getTaskID().toString(), taskAttemptId.toString(), Values.KILLED.name(), String.valueOf(timestamp), hostName, error});
            }
        }
    }

    public static class TaskAttempt
    extends Task {
    }

    public static class Task
    extends KeyValuePair {
        private Map<String, TaskAttempt> taskAttempts = new TreeMap<String, TaskAttempt>();

        public static void logStarted(TaskID taskId, String taskType, long startTime, String splitLocations) {
            ArrayList writer;
            if (!disableHistory && null != (writer = (ArrayList)openJobs.get(JOBTRACKER_UNIQUE_STRING + taskId.getJobID()))) {
                JobHistory.log(writer, RecordTypes.Task, new Keys[]{Keys.TASKID, Keys.TASK_TYPE, Keys.START_TIME, Keys.SPLITS}, new String[]{taskId.toString(), taskType, String.valueOf(startTime), splitLocations});
            }
        }

        public static void logFinished(TaskID taskId, String taskType, long finishTime, Counters counters) {
            ArrayList writer;
            if (!disableHistory && null != (writer = (ArrayList)openJobs.get(JOBTRACKER_UNIQUE_STRING + taskId.getJobID()))) {
                JobHistory.log(writer, RecordTypes.Task, new Keys[]{Keys.TASKID, Keys.TASK_TYPE, Keys.TASK_STATUS, Keys.FINISH_TIME, Keys.COUNTERS}, new String[]{taskId.toString(), taskType, Values.SUCCESS.name(), String.valueOf(finishTime), counters.makeEscapedCompactString()});
            }
        }

        public static void logUpdates(TaskID taskId, long finishTime) {
            ArrayList writer;
            if (!disableHistory && null != (writer = (ArrayList)openJobs.get(JOBTRACKER_UNIQUE_STRING + taskId.getJobID()))) {
                JobHistory.log(writer, RecordTypes.Task, new Keys[]{Keys.TASKID, Keys.FINISH_TIME}, new String[]{taskId.toString(), String.valueOf(finishTime)});
            }
        }

        public static void logFailed(TaskID taskId, String taskType, long time, String error) {
            Task.logFailed(taskId, taskType, time, error, null);
        }

        public static void logFailed(TaskID taskId, String taskType, long time, String error, TaskAttemptID failedDueToAttempt) {
            ArrayList writer;
            if (!disableHistory && null != (writer = (ArrayList)openJobs.get(JOBTRACKER_UNIQUE_STRING + taskId.getJobID()))) {
                String failedAttempt = failedDueToAttempt == null ? "" : failedDueToAttempt.toString();
                JobHistory.log(writer, RecordTypes.Task, new Keys[]{Keys.TASKID, Keys.TASK_TYPE, Keys.TASK_STATUS, Keys.FINISH_TIME, Keys.ERROR, Keys.TASK_ATTEMPT_ID}, new String[]{taskId.toString(), taskType, Values.FAILED.name(), String.valueOf(time), error, failedAttempt});
            }
        }

        public Map<String, TaskAttempt> getTaskAttempts() {
            return this.taskAttempts;
        }
    }

    public static class JobInfo
    extends KeyValuePair {
        private Map<String, Task> allTasks = new TreeMap<String, Task>();

        public JobInfo(String jobId) {
            this.set(Keys.JOBID, jobId);
        }

        public Map<String, Task> getAllTasks() {
            return this.allTasks;
        }

        public static String getLocalJobFilePath(JobID jobId) {
            return System.getProperty("hadoop.log.dir") + File.separator + jobId + "_conf.xml";
        }

        public static String encodeJobHistoryFilePath(String logFile) throws IOException {
            Path rawPath = new Path(logFile);
            String encodedFileName = null;
            try {
                encodedFileName = URLEncoder.encode(rawPath.getName(), "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                IOException ioe = new IOException();
                ioe.initCause(uee);
                ioe.setStackTrace(uee.getStackTrace());
                throw ioe;
            }
            Path encodedPath = new Path(rawPath.getParent(), encodedFileName);
            return encodedPath.toString();
        }

        public static String encodeJobHistoryFileName(String logFileName) throws IOException {
            String encodedFileName = null;
            try {
                encodedFileName = URLEncoder.encode(logFileName, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                IOException ioe = new IOException();
                ioe.initCause(uee);
                ioe.setStackTrace(uee.getStackTrace());
                throw ioe;
            }
            return encodedFileName;
        }

        public static String decodeJobHistoryFileName(String logFileName) throws IOException {
            String decodedFileName = null;
            try {
                decodedFileName = URLDecoder.decode(logFileName, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                IOException ioe = new IOException();
                ioe.initCause(uee);
                ioe.setStackTrace(uee.getStackTrace());
                throw ioe;
            }
            return decodedFileName;
        }

        static String getJobName(JobConf jobConf) {
            String jobName = jobConf.getJobName();
            if (jobName == null || jobName.length() == 0) {
                jobName = "NA";
            }
            return jobName;
        }

        public static String getUserName(JobConf jobConf) {
            String user = jobConf.getUser();
            if (user == null || user.length() == 0) {
                user = "NA";
            }
            return user;
        }

        public static Path getJobHistoryLogLocation(String logFileName) {
            return LOG_DIR == null ? null : new Path(LOG_DIR, logFileName);
        }

        public static Path getJobHistoryLogLocationForUser(String logFileName, JobConf jobConf) {
            Path userLogFile = null;
            Path outputPath = FileOutputFormat.getOutputPath(jobConf);
            String userLogDir = jobConf.get("hadoop.job.history.user.location", outputPath == null ? null : outputPath.toString());
            if ("none".equals(userLogDir)) {
                userLogDir = null;
            }
            if (userLogDir != null) {
                userLogDir = userLogDir + "/" + "_logs" + "/" + "history";
                userLogFile = new Path(userLogDir, logFileName);
            }
            return userLogFile;
        }

        private static String getNewJobHistoryFileName(JobConf jobConf, JobID id) {
            return JOBTRACKER_UNIQUE_STRING + id.toString() + "_" + JobInfo.getUserName(jobConf) + "_" + JobInfo.trimJobName(JobInfo.getJobName(jobConf));
        }

        private static String trimJobName(String jobName) {
            if (jobName.length() > 50) {
                jobName = jobName.substring(0, 50);
            }
            return jobName;
        }

        private static String escapeRegexChars(String string) {
            return "\\Q" + string.replaceAll("\\\\E", "\\\\E\\\\\\\\E\\\\Q") + "\\E";
        }

        public static synchronized String getJobHistoryFileName(JobConf jobConf, JobID id) throws IOException {
            String user = JobInfo.getUserName(jobConf);
            String jobName = JobInfo.trimJobName(JobInfo.getJobName(jobConf));
            FileSystem fs = new Path(LOG_DIR).getFileSystem(jobConf);
            if (LOG_DIR == null) {
                return null;
            }
            final Pattern historyFilePattern = Pattern.compile(jobtrackerHostname + "_" + JobHistory.DIGITS + "_" + id.toString() + "_" + user + "_" + JobInfo.escapeRegexChars(jobName) + "+");
            PathFilter filter = new PathFilter(){

                @Override
                public boolean accept(Path path) {
                    String fileName = path.getName();
                    try {
                        fileName = JobInfo.decodeJobHistoryFileName(fileName);
                    }
                    catch (IOException ioe) {
                        LOG.info("Error while decoding history file " + fileName + "." + " Ignoring file.", ioe);
                        return false;
                    }
                    return historyFilePattern.matcher(fileName).find();
                }
            };
            FileStatus[] statuses = fs.listStatus(new Path(LOG_DIR), filter);
            String filename = null;
            if (statuses.length == 0) {
                LOG.info("Nothing to recover for job " + id);
            } else {
                filename = JobInfo.decodeJobHistoryFileName(statuses[0].getPath().getName());
                if (filename.endsWith(jobName + JobHistory.SECONDARY_FILE_SUFFIX)) {
                    int newLength = filename.length() - JobHistory.SECONDARY_FILE_SUFFIX.length();
                    filename = filename.substring(0, newLength);
                }
                filename = JobInfo.encodeJobHistoryFileName(filename);
                LOG.info("Recovered job history filename for job " + id + " is " + filename);
            }
            return filename;
        }

        static synchronized void checkpointRecovery(String fileName, JobConf conf) throws IOException {
            FileSystem fs;
            Path logPath = JobInfo.getJobHistoryLogLocation(fileName);
            if (logPath != null) {
                fs = logPath.getFileSystem(conf);
                LOG.info("Deleting job history file " + logPath.getName());
                fs.delete(logPath, false);
            }
            if ((logPath = JobInfo.getJobHistoryLogLocationForUser(fileName, conf)) != null) {
                fs = logPath.getFileSystem(conf);
                fs.delete(logPath, false);
            }
        }

        static String getSecondaryJobHistoryFile(String filename) throws IOException {
            return JobInfo.encodeJobHistoryFileName(JobInfo.decodeJobHistoryFileName(filename) + JobHistory.SECONDARY_FILE_SUFFIX);
        }

        public static synchronized Path recoverJobHistoryFile(JobConf conf, Path logFilePath) throws IOException {
            Path ret;
            FileSystem fs = logFilePath.getFileSystem(conf);
            String logFileName = logFilePath.getName();
            String tmpFilename = JobInfo.getSecondaryJobHistoryFile(logFileName);
            Path logDir = logFilePath.getParent();
            Path tmpFilePath = new Path(logDir, tmpFilename);
            if (fs.exists(logFilePath)) {
                LOG.info(logFileName + " exists!");
                if (fs.exists(tmpFilePath)) {
                    LOG.info("Deleting " + tmpFilename + "  and using " + logFileName + " for recovery.");
                    fs.delete(tmpFilePath, false);
                }
                ret = tmpFilePath;
            } else {
                LOG.info(logFileName + " doesnt exist! Using " + tmpFilename + " for recovery.");
                if (fs.exists(tmpFilePath)) {
                    LOG.info("Renaming " + tmpFilename + " to " + logFileName);
                    fs.rename(tmpFilePath, logFilePath);
                    ret = tmpFilePath;
                } else {
                    ret = logFilePath;
                }
            }
            logFilePath = JobInfo.getJobHistoryLogLocationForUser(logFileName, conf);
            if (logFilePath != null) {
                fs = logFilePath.getFileSystem(conf);
                logDir = logFilePath.getParent();
                tmpFilePath = new Path(logDir, tmpFilename);
                if (fs.exists(logFilePath)) {
                    LOG.info(logFileName + " exists!");
                    if (fs.exists(tmpFilePath)) {
                        LOG.info("Deleting " + tmpFilename + "  and making " + logFileName + " as the master history file for user.");
                        fs.delete(tmpFilePath, false);
                    }
                } else {
                    LOG.info(logFileName + " doesnt exist! Using " + tmpFilename + " as the master history file for user.");
                    if (fs.exists(tmpFilePath)) {
                        LOG.info("Renaming " + tmpFilename + " to " + logFileName + " in user directory");
                        fs.rename(tmpFilePath, logFilePath);
                    }
                }
            }
            return ret;
        }

        static synchronized void finalizeRecovery(JobID id, JobConf conf) throws IOException {
            FileSystem fs;
            String masterLogFileName = JobInfo.getJobHistoryFileName(conf, id);
            if (masterLogFileName == null) {
                return;
            }
            Path masterLogPath = JobInfo.getJobHistoryLogLocation(masterLogFileName);
            String tmpLogFileName = JobInfo.getSecondaryJobHistoryFile(masterLogFileName);
            Path tmpLogPath = JobInfo.getJobHistoryLogLocation(tmpLogFileName);
            if (masterLogPath != null && (fs = masterLogPath.getFileSystem(conf)).exists(tmpLogPath)) {
                LOG.info("Renaming " + tmpLogFileName + " to " + masterLogFileName);
                fs.rename(tmpLogPath, masterLogPath);
            }
            masterLogPath = JobInfo.getJobHistoryLogLocationForUser(masterLogFileName, conf);
            tmpLogPath = JobInfo.getJobHistoryLogLocationForUser(tmpLogFileName, conf);
            if (masterLogPath != null && (fs = masterLogPath.getFileSystem(conf)).exists(tmpLogPath)) {
                LOG.info("Renaming " + tmpLogFileName + " to " + masterLogFileName + " in user directory");
                fs.rename(tmpLogPath, masterLogPath);
            }
        }

        static void cleanupJob(JobID id) {
            String localJobFilePath = JobInfo.getLocalJobFilePath(id);
            File f = new File(localJobFilePath);
            LOG.info("Deleting localized job conf at " + f);
            if (!f.delete()) {
                LOG.debug("Failed to delete file " + f);
            }
        }

        @Deprecated
        public static void logSubmitted(JobID jobId, JobConf jobConf, String jobConfPath, long submitTime) throws IOException {
            JobInfo.logSubmitted(jobId, jobConf, jobConfPath, submitTime, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void logSubmitted(JobID jobId, JobConf jobConf, String jobConfPath, long submitTime, boolean restarted) throws IOException {
            FileSystem fs = null;
            String userLogDir = null;
            String jobUniqueString = JOBTRACKER_UNIQUE_STRING + jobId;
            if (!disableHistory) {
                String jobName = JobInfo.getJobName(jobConf);
                String user = JobInfo.getUserName(jobConf);
                String logFileName = null;
                if (restarted) {
                    logFileName = JobInfo.getJobHistoryFileName(jobConf, jobId);
                    if (logFileName == null) {
                        logFileName = JobInfo.encodeJobHistoryFileName(JobInfo.getNewJobHistoryFileName(jobConf, jobId));
                    }
                } else {
                    logFileName = JobInfo.encodeJobHistoryFileName(JobInfo.getNewJobHistoryFileName(jobConf, jobId));
                }
                Path logFile = JobInfo.getJobHistoryLogLocation(logFileName);
                Path userLogFile = JobInfo.getJobHistoryLogLocationForUser(logFileName, jobConf);
                try {
                    ArrayList<PrintWriter> writers = new ArrayList<PrintWriter>();
                    FSDataOutputStream out = null;
                    PrintWriter writer = null;
                    if (LOG_DIR != null) {
                        fs = new Path(LOG_DIR).getFileSystem(jobConf);
                        if (restarted) {
                            logFile = JobInfo.recoverJobHistoryFile(jobConf, logFile);
                            logFileName = logFile.getName();
                        }
                        int defaultBufferSize = fs.getConf().getInt("io.file.buffer.size", 4096);
                        out = fs.create(logFile, new FsPermission(HISTORY_FILE_PERMISSION), true, defaultBufferSize, fs.getDefaultReplication(), jobHistoryBlockSize, null);
                        writer = new PrintWriter(out);
                        writers.add(writer);
                    }
                    if (userLogFile != null) {
                        userLogDir = userLogFile.getParent().toString();
                        userLogFile = new Path(userLogDir, logFileName);
                        fs = userLogFile.getFileSystem(jobConf);
                        out = fs.create(userLogFile, true, 4096);
                        writer = new PrintWriter(out);
                        writers.add(writer);
                    }
                    openJobs.put(jobUniqueString, writers);
                    MetaInfoManager.logMetaInfo(writers);
                    JobHistory.log(writers, RecordTypes.Job, new Keys[]{Keys.JOBID, Keys.JOBNAME, Keys.USER, Keys.SUBMIT_TIME, Keys.JOBCONF}, new String[]{jobId.toString(), jobName, user, String.valueOf(submitTime), jobConfPath});
                }
                catch (IOException e) {
                    LOG.error("Failed creating job history log file, disabling history", e);
                    disableHistory = true;
                }
            }
            String localJobFilePath = JobInfo.getLocalJobFilePath(jobId);
            File localJobFile = new File(localJobFilePath);
            FileOutputStream jobOut = null;
            try {
                jobOut = new FileOutputStream(localJobFile);
                jobConf.writeXml(jobOut);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Job conf for " + jobId + " stored at " + localJobFile.getAbsolutePath());
                }
            }
            catch (IOException ioe) {
                LOG.error("Failed to store job conf on the local filesystem ", ioe);
            }
            finally {
                if (jobOut != null) {
                    try {
                        jobOut.close();
                    }
                    catch (IOException ie) {
                        LOG.info("Failed to close the job configuration file " + StringUtils.stringifyException(ie));
                    }
                }
            }
            Path jobFilePath = null;
            if (LOG_DIR != null) {
                jobFilePath = new Path(LOG_DIR + File.separator + jobUniqueString + "_conf.xml");
            }
            Path userJobFilePath = null;
            if (userLogDir != null) {
                userJobFilePath = new Path(userLogDir + File.separator + jobUniqueString + "_conf.xml");
            }
            FSDataOutputStream jobFileOut = null;
            try {
                if (LOG_DIR != null) {
                    fs = new Path(LOG_DIR).getFileSystem(jobConf);
                    int defaultBufferSize = fs.getConf().getInt("io.file.buffer.size", 4096);
                    if (!fs.exists(jobFilePath)) {
                        jobFileOut = fs.create(jobFilePath, new FsPermission(HISTORY_FILE_PERMISSION), true, defaultBufferSize, fs.getDefaultReplication(), fs.getDefaultBlockSize(), null);
                        jobConf.writeXml(jobFileOut);
                        jobFileOut.close();
                    }
                }
                if (userLogDir != null) {
                    fs = new Path(userLogDir).getFileSystem(jobConf);
                    jobFileOut = fs.create(userJobFilePath);
                    jobConf.writeXml(jobFileOut);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Job conf for " + jobId + " stored at " + jobFilePath + "and" + userJobFilePath);
                }
            }
            catch (IOException ioe) {
                LOG.error("Failed to store job conf on the local filesystem ", ioe);
            }
            finally {
                if (jobFileOut != null) {
                    try {
                        jobFileOut.close();
                    }
                    catch (IOException ie) {
                        LOG.info("Failed to close the job configuration file " + StringUtils.stringifyException(ie));
                    }
                }
            }
        }

        public static void logInited(JobID jobId, long startTime, int totalMaps, int totalReduces) {
            if (!disableHistory) {
                String logFileKey = JOBTRACKER_UNIQUE_STRING + jobId;
                ArrayList writer = (ArrayList)openJobs.get(logFileKey);
                if (null != writer) {
                    JobHistory.log(writer, RecordTypes.Job, new Keys[]{Keys.JOBID, Keys.LAUNCH_TIME, Keys.TOTAL_MAPS, Keys.TOTAL_REDUCES, Keys.JOB_STATUS}, new String[]{jobId.toString(), String.valueOf(startTime), String.valueOf(totalMaps), String.valueOf(totalReduces), Values.PREP.name()});
                }
            }
        }

        @Deprecated
        public static void logStarted(JobID jobId, long startTime, int totalMaps, int totalReduces) {
            JobInfo.logStarted(jobId);
        }

        public static void logStarted(JobID jobId) {
            if (!disableHistory) {
                String logFileKey = JOBTRACKER_UNIQUE_STRING + jobId;
                ArrayList writer = (ArrayList)openJobs.get(logFileKey);
                if (null != writer) {
                    JobHistory.log(writer, RecordTypes.Job, new Keys[]{Keys.JOBID, Keys.JOB_STATUS}, new String[]{jobId.toString(), Values.RUNNING.name()});
                }
            }
        }

        public static void logFinished(JobID jobId, long finishTime, int finishedMaps, int finishedReduces, int failedMaps, int failedReduces, Counters counters) {
            if (!disableHistory) {
                String logFileKey = JOBTRACKER_UNIQUE_STRING + jobId;
                ArrayList writer = (ArrayList)openJobs.get(logFileKey);
                if (null != writer) {
                    JobHistory.log(writer, RecordTypes.Job, new Keys[]{Keys.JOBID, Keys.FINISH_TIME, Keys.JOB_STATUS, Keys.FINISHED_MAPS, Keys.FINISHED_REDUCES, Keys.FAILED_MAPS, Keys.FAILED_REDUCES, Keys.COUNTERS}, new String[]{jobId.toString(), Long.toString(finishTime), Values.SUCCESS.name(), String.valueOf(finishedMaps), String.valueOf(finishedReduces), String.valueOf(failedMaps), String.valueOf(failedReduces), counters.makeEscapedCompactString()});
                    for (PrintWriter out : writer) {
                        out.close();
                    }
                    openJobs.remove(logFileKey);
                }
                Thread historyCleaner = new Thread(new HistoryCleaner());
                historyCleaner.start();
            }
        }

        public static void logFailed(JobID jobid, long timestamp, int finishedMaps, int finishedReduces) {
            if (!disableHistory) {
                String logFileKey = JOBTRACKER_UNIQUE_STRING + jobid;
                ArrayList writer = (ArrayList)openJobs.get(logFileKey);
                if (null != writer) {
                    JobHistory.log(writer, RecordTypes.Job, new Keys[]{Keys.JOBID, Keys.FINISH_TIME, Keys.JOB_STATUS, Keys.FINISHED_MAPS, Keys.FINISHED_REDUCES}, new String[]{jobid.toString(), String.valueOf(timestamp), Values.FAILED.name(), String.valueOf(finishedMaps), String.valueOf(finishedReduces)});
                    for (PrintWriter out : writer) {
                        out.close();
                    }
                    openJobs.remove(logFileKey);
                }
            }
        }

        public static void logKilled(JobID jobid, long timestamp, int finishedMaps, int finishedReduces) {
            if (!disableHistory) {
                String logFileKey = JOBTRACKER_UNIQUE_STRING + jobid;
                ArrayList writer = (ArrayList)openJobs.get(logFileKey);
                if (null != writer) {
                    JobHistory.log(writer, RecordTypes.Job, new Keys[]{Keys.JOBID, Keys.FINISH_TIME, Keys.JOB_STATUS, Keys.FINISHED_MAPS, Keys.FINISHED_REDUCES}, new String[]{jobid.toString(), String.valueOf(timestamp), Values.KILLED.name(), String.valueOf(finishedMaps), String.valueOf(finishedReduces)});
                    for (PrintWriter out : writer) {
                        out.close();
                    }
                    openJobs.remove(logFileKey);
                }
            }
        }

        public static void logJobPriority(JobID jobid, JobPriority priority) {
            if (!disableHistory) {
                String logFileKey = JOBTRACKER_UNIQUE_STRING + jobid;
                ArrayList writer = (ArrayList)openJobs.get(logFileKey);
                if (null != writer) {
                    JobHistory.log(writer, RecordTypes.Job, new Keys[]{Keys.JOBID, Keys.JOB_PRIORITY}, new String[]{jobid.toString(), priority.toString()});
                }
            }
        }

        @Deprecated
        public static void logJobInfo(JobID jobid, long submitTime, long launchTime, int restartCount) {
            JobInfo.logJobInfo(jobid, submitTime, launchTime);
        }

        public static void logJobInfo(JobID jobid, long submitTime, long launchTime) {
            if (!disableHistory) {
                String logFileKey = JOBTRACKER_UNIQUE_STRING + jobid;
                ArrayList writer = (ArrayList)openJobs.get(logFileKey);
                if (null != writer) {
                    JobHistory.log(writer, RecordTypes.Job, new Keys[]{Keys.JOBID, Keys.SUBMIT_TIME, Keys.LAUNCH_TIME}, new String[]{jobid.toString(), String.valueOf(submitTime), String.valueOf(launchTime)});
                }
            }
        }
    }

    static class KeyValuePair {
        private Map<Keys, String> values = new HashMap<Keys, String>();

        KeyValuePair() {
        }

        public String get(Keys k) {
            String s = this.values.get((Object)k);
            return s == null ? "" : s;
        }

        public int getInt(Keys k) {
            String s = this.values.get((Object)k);
            if (null != s) {
                return Integer.parseInt(s);
            }
            return 0;
        }

        public long getLong(Keys k) {
            String s = this.values.get((Object)k);
            if (null != s) {
                return Long.parseLong(s);
            }
            return 0L;
        }

        public void set(Keys k, String s) {
            this.values.put(k, s);
        }

        public void set(Map<Keys, String> m) {
            this.values.putAll(m);
        }

        public synchronized void handle(Map<Keys, String> values) {
            this.set(values);
        }

        public Map<Keys, String> getValues() {
            return this.values;
        }
    }

    static class MetaInfoManager
    implements Listener {
        private long version = 0L;
        private KeyValuePair pairs = new KeyValuePair();

        public MetaInfoManager(String line) throws IOException {
            if (null != line) {
                JobHistory.parseLine(line, this, false);
            }
        }

        char getLineDelim() {
            if (this.version == 0L) {
                return '\"';
            }
            return '.';
        }

        boolean isValueEscaped() {
            return this.version != 0L;
        }

        @Override
        public void handle(RecordTypes recType, Map<Keys, String> values) throws IOException {
            if (RecordTypes.Meta == recType) {
                this.pairs.handle(values);
                this.version = this.pairs.getLong(Keys.VERSION);
            }
        }

        static void logMetaInfo(ArrayList<PrintWriter> writers) {
            if (!disableHistory && null != writers) {
                JobHistory.log(writers, RecordTypes.Meta, new Keys[]{Keys.VERSION}, new String[]{String.valueOf(1L)});
            }
        }
    }

    public static enum Values {
        SUCCESS,
        FAILED,
        KILLED,
        MAP,
        REDUCE,
        CLEANUP,
        RUNNING,
        PREP,
        SETUP;

    }

    public static enum Keys {
        JOBTRACKERID,
        START_TIME,
        FINISH_TIME,
        JOBID,
        JOBNAME,
        USER,
        JOBCONF,
        SUBMIT_TIME,
        LAUNCH_TIME,
        TOTAL_MAPS,
        TOTAL_REDUCES,
        FAILED_MAPS,
        FAILED_REDUCES,
        FINISHED_MAPS,
        FINISHED_REDUCES,
        JOB_STATUS,
        TASKID,
        HOSTNAME,
        TASK_TYPE,
        ERROR,
        TASK_ATTEMPT_ID,
        TASK_STATUS,
        COPY_PHASE,
        SORT_PHASE,
        REDUCE_PHASE,
        SHUFFLE_FINISHED,
        SORT_FINISHED,
        COUNTERS,
        SPLITS,
        JOB_PRIORITY,
        HTTP_PORT,
        TRACKER_NAME,
        STATE_STRING,
        VERSION;

    }

    public static enum RecordTypes {
        Jobtracker,
        Job,
        Task,
        MapAttempt,
        ReduceAttempt,
        Meta;

    }
}

